/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.internal.scheduling.AsyncUtils;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.langlib.array.utils.ArrayUtils;
import org.ballerinalang.langlib.array.utils.GetFunction;

public class Map {
    private static final StrandMetadata METADATA = new StrandMetadata("ballerina", "lang.array", "1.1.0", "map");

    public static BArray map(BArray arr, BFunctionPointer<Object, Object> func) {
        GetFunction getFn;
        Type elemType = ((FunctionType)func.getType()).getReturnType();
        ArrayType retArrType = TypeCreator.createArrayType((Type)elemType);
        BArray retArr = ValueCreator.createArrayValue((ArrayType)retArrType);
        int size = arr.size();
        Type arrType = arr.getType();
        switch (arrType.getTag()) {
            case 20: {
                getFn = BArray::get;
                break;
            }
            case 32: {
                getFn = BArray::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "map()");
            }
        }
        AtomicInteger index = new AtomicInteger(-1);
        Strand parentStrand = Scheduler.getStrand();
        AsyncUtils.invokeFunctionPointerAsyncIteratively(func, null, (StrandMetadata)METADATA, (int)size, () -> new Object[]{parentStrand, getFn.get(arr, index.incrementAndGet()), true}, result -> retArr.add((long)index.get(), result), () -> retArr, (Scheduler)Scheduler.getStrand().scheduler);
        return retArr;
    }
}

