/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import java.util.ArrayList;
import org.ballerinalang.langlib.array.utils.ArrayUtils;

public class Slice {
    public static BArray slice(BArray arr, long startIndex, long endIndex) {
        BArray slicedArr;
        int size = arr.size();
        if (startIndex < 0L) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, (Object[])new Object[]{startIndex, size});
        }
        if (endIndex > (long)size) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, (Object[])new Object[]{endIndex, size});
        }
        long sliceSize = endIndex - startIndex;
        if (sliceSize < 0L) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, (Object[])new Object[]{sliceSize, size});
        }
        Type arrType = arr.getType();
        switch (arrType.getTag()) {
            case 20: {
                slicedArr = arr.slice(startIndex, endIndex);
                break;
            }
            case 32: {
                TupleType tupleType = (TupleType)arrType;
                ArrayList<Type> memTypes = new ArrayList<Type>(tupleType.getTupleTypes());
                Type restType = tupleType.getRestType();
                if (restType != null) {
                    memTypes.add(restType);
                }
                UnionType unionType = TypeCreator.createUnionType(memTypes);
                ArrayType slicedArrType = TypeCreator.createArrayType((Type)unionType, (int)((int)(endIndex - startIndex)));
                slicedArr = ValueCreator.createArrayValue((ArrayType)slicedArrType);
                long i = startIndex;
                long j = 0L;
                while (i < endIndex) {
                    slicedArr.add(j, arr.getRefValue(i));
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "slice()");
            }
        }
        return slicedArr;
    }
}

