/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.TypeTags;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import java.math.BigDecimal;
import java.util.List;
import java.util.PrimitiveIterator;
import org.ballerinalang.langlib.array.utils.ArrayUtils;

public class Sort {
    public static BArray sort(BArray arr, Object direction, Object func) {
        Type type;
        ArrayUtils.checkIsArrayOnlyOperation(arr.getType(), "sort()");
        BFunctionPointer function = (BFunctionPointer)func;
        Type elemType = ((ArrayType)arr.getType()).getElementType();
        boolean isAscending = true;
        if (direction.toString().equals("descending")) {
            isAscending = false;
        }
        Object[][] sortArr = new Object[arr.size()][2];
        Object[][] sortArrClone = new Object[arr.size()][2];
        if (function != null) {
            boolean elementTypeIdentified = false;
            elemType = ((FunctionType)function.getType()).getReturnType();
            for (int i = 0; i < arr.size(); ++i) {
                Type sortArrElemType;
                sortArr[i][0] = function.call((Object)new Object[]{Scheduler.getStrand(), arr.get((long)i), true});
                if (!elementTypeIdentified && elemType.getTag() == 21 && ((UnionType)elemType).getMemberTypes().size() > 2 && (sortArrElemType = TypeChecker.getType((Object)sortArr[i][0])).getTag() != 10) {
                    elemType = sortArrElemType;
                    elementTypeIdentified = true;
                }
                sortArr[i][1] = arr.get((long)i);
            }
        } else {
            for (int i = 0; i < arr.size(); ++i) {
                Object object = arr.get((long)i);
                sortArr[i][1] = object;
                sortArr[i][0] = object;
            }
        }
        if (elemType.getTag() == 21) {
            elemType = Sort.getMemberType((UnionType)elemType);
        }
        if (elemType.getTag() == 20 && (type = ((ArrayType)elemType).getElementType()).getTag() == 21) {
            Type memberType = Sort.getMemberType((UnionType)type);
            elemType = TypeCreator.createArrayType((Type)memberType);
        }
        Sort.mergesort(sortArr, sortArrClone, 0, sortArr.length - 1, isAscending, elemType);
        for (int k = 0; k < sortArr.length; ++k) {
            arr.add((long)k, sortArr[k][1]);
        }
        return arr;
    }

    private static Type getMemberType(UnionType unionType) {
        List memberTypes = unionType.getMemberTypes();
        for (Type type : memberTypes) {
            if (type.getTag() == 10) continue;
            return type;
        }
        return unionType;
    }

    private static void mergesort(Object[][] input, Object[][] aux, int lo, int hi, boolean isAscending, Type type) {
        if (hi <= lo) {
            return;
        }
        int mid = lo + (hi - lo) / 2;
        Sort.mergesort(input, aux, lo, mid, isAscending, type);
        Sort.mergesort(input, aux, mid + 1, hi, isAscending, type);
        Sort.merge(input, aux, lo, mid, hi, isAscending, type);
    }

    private static void merge(Object[][] input, Object[][] aux, int lo, int mid, int hi, boolean isAscending, Type type) {
        if (hi + 1 - lo >= 0) {
            System.arraycopy(input, lo, aux, lo, hi + 1 - lo);
        }
        int i = lo;
        int j = mid + 1;
        for (int k = lo; k <= hi; ++k) {
            int index = i > mid ? j++ : (j > hi ? i++ : (isAscending && Sort.sortFunc(aux[j][0], aux[i][0], type, true) < 0 ? j++ : (!isAscending && Sort.sortFunc(aux[i][0], aux[j][0], type, false) < 0 ? j++ : i++)));
            input[k] = aux[index];
        }
    }

    private static int sortFunc(Object value1, Object value2, Type type, boolean isAscending) {
        if (value1 == null) {
            if (value2 == null) {
                return 0;
            }
            if (isAscending) {
                return 1;
            }
            return -1;
        }
        if (value2 == null) {
            if (isAscending) {
                return -1;
            }
            return 1;
        }
        if (TypeTags.isIntegerTypeTag((int)type.getTag())) {
            return Long.compare((Long)value1, (Long)value2);
        }
        if (type.getTag() == 3) {
            if (Double.isNaN((Double)value1)) {
                if (Double.isNaN((Double)value2)) {
                    return 0;
                }
                if (isAscending) {
                    return 1;
                }
                return -1;
            }
            if (Double.isNaN((Double)value2)) {
                if (isAscending) {
                    return -1;
                }
                return 1;
            }
            if ((Double)value1 == 0.0 && (Double)value2 == 0.0) {
                return 0;
            }
            return Double.compare((Double)value1, (Double)value2);
        }
        if (type.getTag() == 4) {
            return new BigDecimal(value1.toString()).compareTo(new BigDecimal(value2.toString()));
        }
        if (type.getTag() == 6) {
            return Boolean.compare((Boolean)value1, (Boolean)value2);
        }
        if (TypeTags.isStringTypeTag((int)type.getTag())) {
            return Sort.codePointCompare(value1.toString(), value2.toString());
        }
        if (type.getTag() == 2) {
            return Integer.compare((Integer)value1, (Integer)value2);
        }
        if (type.getTag() == 20) {
            int lengthVal1 = ((BArray)value1).size();
            int lengthVal2 = ((BArray)value2).size();
            if (lengthVal1 == 0) {
                if (lengthVal2 == 0) {
                    return 0;
                }
                return -1;
            }
            if (lengthVal2 == 0) {
                return 1;
            }
            int len = Math.min(lengthVal1, lengthVal2);
            int c = 0;
            for (int i = 0; i < len && (c = Sort.sortFunc(((BArray)value1).get((long)i), ((BArray)value2).get((long)i), ((ArrayType)type).getElementType(), isAscending)) == 0; ++i) {
                if (i != len - 1 || lengthVal1 >= lengthVal2) continue;
                return -1;
            }
            return c;
        }
        throw ErrorCreator.createError((BString)BallerinaErrorReasons.getModulePrefixedReason((String)"lang.array", (String)"InvalidTypeToSort"), (BString)StringUtils.fromString((String)("expected an ordered type, but found '" + type.toString() + "'")));
    }

    private static int codePointCompare(String str1, String str2) {
        PrimitiveIterator.OfInt iterator1 = str1.codePoints().iterator();
        PrimitiveIterator.OfInt iterator2 = str2.codePoints().iterator();
        while (iterator1.hasNext()) {
            Integer codePoint2;
            if (!iterator2.hasNext()) {
                return 1;
            }
            Integer codePoint1 = iterator1.next();
            int cmp = codePoint1.compareTo(codePoint2 = iterator2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }
}

