/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;

public class ToBase16 {
    private static final char[] chars = "0123456789abcdef".toCharArray();
    private static final BString NOT_SUPPORTED_ERROR_DETAIL = StringUtils.fromString((String)"toBase16() is only supported on 'byte[]'");

    public static BString toBase16(BArray arr) {
        Type arrType = arr.getType();
        if (arrType.getTag() != 20 || ((ArrayType)arrType).getElementType().getTag() != 2) {
            throw ErrorCreator.createError((BString)BallerinaErrorReasons.getModulePrefixedReason((String)"lang.array", (String)"OperationNotSupported"), (BString)NOT_SUPPORTED_ERROR_DETAIL);
        }
        byte[] bytes = arr.getBytes();
        char[] base16Chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            base16Chars[i * 2] = chars[v >>> 4];
            base16Chars[i * 2 + 1] = chars[v & 0xF];
        }
        return StringUtils.fromString((String)new String(base16Chars));
    }
}

