/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.langlib.array.utils.GetFunction;

public class ArrayUtils {
    @Deprecated
    public static void add(BArray arr, int elemTypeTag, long index, Object value) {
        switch (elemTypeTag) {
            case 1: {
                arr.add(index, ((Long)value).longValue());
                break;
            }
            case 6: {
                arr.add(index, ((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                arr.add(index, ((Integer)value).byteValue());
                break;
            }
            case 3: {
                arr.add(index, ((Double)value).doubleValue());
                break;
            }
            case 5: {
                arr.add(index, (String)value);
                break;
            }
            default: {
                arr.add(index, value);
            }
        }
    }

    public static GetFunction getElementAccessFunction(Type arrType, String funcName) {
        switch (arrType.getTag()) {
            case 20: {
                return BArray::get;
            }
            case 32: {
                return BArray::getRefValue;
            }
        }
        throw ArrayUtils.createOpNotSupportedError(arrType, funcName);
    }

    public static void checkIsArrayOnlyOperation(Type arrType, String op) {
        if (arrType.getTag() != 20) {
            throw ArrayUtils.createOpNotSupportedError(arrType, op);
        }
    }

    public static BError createOpNotSupportedError(Type type, String op) {
        return ErrorCreator.createError((BString)BallerinaErrorReasons.getModulePrefixedReason((String)"lang.array", (String)"OperationNotSupported"), (BString)StringUtils.fromString((String)String.format("%s not supported on type '%s'", op, type.getQualifiedName())));
    }
}

