/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.auth.ldap.nativeimpl;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ballerinalang.auth.ldap.CommonLdapConfiguration;
import org.ballerinalang.auth.ldap.UserStoreException;
import org.ballerinalang.auth.ldap.util.LdapUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="auth", functionName="LdapAuthStoreProvider.getScopesOfUser", args={@Argument(name="username", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.STRING)}, isPublic=true)
public class GetLdapScopesOfUser
extends BlockingNativeCallableUnit {
    private static final Log LOG = LogFactory.getLog(GetLdapScopesOfUser.class);
    private CommonLdapConfiguration ldapConfiguration;
    private DirContext ldapConnectionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Context context) {
        try {
            BMap authStore = (BMap)context.getRefArgument(0);
            LdapUtils.setServiceName((String)authStore.getNativeData("instanceId"));
            this.ldapConnectionContext = (DirContext)authStore.getNativeData("connectionContext");
            this.ldapConfiguration = (CommonLdapConfiguration)authStore.getNativeData("ldapConfiguration");
            String userName = context.getStringArgument(0);
            String[] externalRoles = this.doGetGroupsListOfUser(userName, this.ldapConfiguration);
            context.setReturnValues(new BValue[]{new BStringArray(externalRoles)});
        }
        catch (NamingException | UserStoreException e) {
            context.setReturnValues(new BValue[]{new BStringArray()});
        }
        finally {
            LdapUtils.removeServiceName();
        }
    }

    private String[] doGetGroupsListOfUser(String userName, CommonLdapConfiguration ldapAuthConfig) throws UserStoreException, NamingException {
        List<String> searchBase = ldapAuthConfig.getGroupSearchBase();
        return this.getLDAPGroupsListOfUser(userName, searchBase, ldapAuthConfig);
    }

    private String[] getLDAPGroupsListOfUser(String userName, List<String> searchBase, CommonLdapConfiguration ldapAuthConfig) throws UserStoreException, NamingException {
        String membershipValue;
        if (userName == null) {
            throw new BallerinaException("userName value is null.");
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String searchFilter = ldapAuthConfig.getGroupNameListFilter();
        String roleNameProperty = ldapAuthConfig.getGroupNameAttribute();
        String membershipProperty = ldapAuthConfig.getMembershipAttribute();
        String nameInSpace = this.getNameInSpaceForUserName(userName, this.ldapConfiguration);
        if (membershipProperty == null || membershipProperty.length() < 1) {
            throw new BallerinaException("membershipAttribute not set in configuration");
        }
        if (nameInSpace != null) {
            LdapName ldn = new LdapName(nameInSpace);
            if ("memberUid".equals(ldapAuthConfig.getMembershipAttribute())) {
                List<Rdn> rdns = ldn.getRdns();
                membershipValue = rdns.get(rdns.size() - 1).getValue().toString();
            } else {
                membershipValue = this.escapeLdapNameForFilter(ldn);
            }
        } else {
            return new String[0];
        }
        searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + membershipValue + "))";
        String[] returnedAtts = new String[]{roleNameProperty};
        searchCtls.setReturningAttributes(returnedAtts);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading roles with the membershipProperty Property: " + membershipProperty));
        }
        List<String> list = this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty, false);
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListOfNames(List<String> searchBases, String searchFilter, SearchControls searchCtls, String property, boolean appendDn) throws NamingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Result for searchBase: " + searchBases + " searchFilter: " + searchFilter + " property:" + property + " appendDN: " + appendDn));
        }
        ArrayList<String> names = new ArrayList<String>();
        NamingEnumeration<SearchResult> answer = null;
        try {
            for (String searchBase : searchBases) {
                answer = this.ldapConnectionContext.search(LdapUtils.escapeDNForSearch(searchBase), searchFilter, searchCtls);
                while (answer.hasMoreElements()) {
                    Attribute attr;
                    SearchResult searchResult = answer.next();
                    if (searchResult.getAttributes() == null || (attr = searchResult.getAttributes().get(property)) == null) continue;
                    NamingEnumeration<?> vals = attr.getAll();
                    while (vals.hasMoreElements()) {
                        String name = (String)vals.nextElement();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Found user: " + name));
                        }
                        names.add(name);
                    }
                }
                if (!LOG.isDebugEnabled()) continue;
                for (String name : names) {
                    LOG.debug((Object)("Result  :  " + name));
                }
            }
        }
        finally {
            LdapUtils.closeNamingEnumeration(answer);
        }
        return names;
    }

    private String getNameInSpaceForUserName(String userName, CommonLdapConfiguration ldapConfiguration) throws UserStoreException, NamingException {
        return LdapUtils.getNameInSpaceForUsernameFromLDAP(userName, ldapConfiguration, this.ldapConnectionContext);
    }

    private String escapeLdapNameForFilter(LdapName ldn) {
        if (ldn == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Received null value to escape special characters. Returning null");
            }
            return null;
        }
        StringBuilder escapedDN = new StringBuilder();
        for (int i = ldn.size() - 1; i > -1; --i) {
            escapedDN = escapedDN.append(this.escapeSpecialCharactersForFilterWithStarAsRegex(ldn.get(i)));
            if (i == 0) continue;
            escapedDN = escapedDN.append(",");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Escaped DN value for filter : " + escapedDN.toString()));
        }
        return escapedDN.toString();
    }

    private String escapeSpecialCharactersForFilterWithStarAsRegex(String filter) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < filter.length(); ++i) {
            char currentChar = filter.charAt(i);
            switch (currentChar) {
                case '\\': {
                    if (filter.charAt(i + 1) == '*') {
                        sb.append("\\2a");
                        ++i;
                        continue block6;
                    }
                    sb.append("\\5c");
                    continue block6;
                }
                case '(': {
                    sb.append("\\28");
                    continue block6;
                }
                case ')': {
                    sb.append("\\29");
                    continue block6;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block6;
                }
                default: {
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }
}

