/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.auth.ldap;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.ballerinalang.auth.ldap.CommonLdapConfiguration;
import org.ballerinalang.auth.ldap.LdapSslSocketFactory;
import org.ballerinalang.auth.ldap.util.LdapUtils;

public class LdapConnectionContext {
    private Hashtable environment;

    public LdapConnectionContext(CommonLdapConfiguration ldapConfiguration) {
        boolean isLDAPConnectionPoolingEnabled;
        String connectionURL = ldapConfiguration.getConnectionURL();
        String connectionName = ldapConfiguration.getConnectionName();
        String connectionPassword = ldapConfiguration.getConnectionPassword();
        this.environment = new Hashtable();
        this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.environment.put("java.naming.security.authentication", "simple");
        if (connectionName != null) {
            this.environment.put("java.naming.security.principal", connectionName);
        }
        if (connectionPassword != null) {
            this.environment.put("java.naming.security.credentials", connectionPassword);
        }
        if (connectionURL != null) {
            this.environment.put("java.naming.provider.url", connectionURL);
        }
        this.environment.put("com.sun.jndi.ldap.connect.pool", (isLDAPConnectionPoolingEnabled = ldapConfiguration.isConnectionPoolingEnabled()) ? "true" : "false");
        if (LdapUtils.isLdapsUrl(connectionURL)) {
            this.environment.put("java.naming.security.protocol", "ssl");
            this.environment.put("java.naming.ldap.factory.socket", LdapSslSocketFactory.class.getName());
        }
        String connectTimeout = String.valueOf(ldapConfiguration.getLdapConnectionTimeout());
        String readTimeout = String.valueOf(ldapConfiguration.getReadTimeout());
        if (!connectTimeout.trim().isEmpty()) {
            this.environment.put("com.sun.jndi.ldap.connect.timeout", connectTimeout);
        } else {
            this.environment.put("com.sun.jndi.ldap.connect.timeout", "5000");
        }
        if (!LdapUtils.isNullOrEmptyAfterTrim(readTimeout)) {
            this.environment.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        }
    }

    public DirContext getContext() throws NamingException {
        return new InitialDirContext(this.environment);
    }

    public LdapContext getContextWithCredentials(String userDN, byte[] password) throws NamingException {
        Hashtable<String, Object> tempEnv = new Hashtable<String, Object>();
        tempEnv.putAll(this.environment);
        tempEnv.put("java.naming.security.principal", userDN);
        tempEnv.put("java.naming.security.credentials", password);
        return this.getContextForEnvironmentVariables(tempEnv);
    }

    private LdapContext getContextForEnvironmentVariables(Hashtable<?, ?> environment) throws NamingException {
        Hashtable tempEnv = new Hashtable();
        tempEnv.putAll(environment);
        InitialLdapContext context = new InitialLdapContext(tempEnv, null);
        return context;
    }
}

