/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.auth.ldap;

import java.io.File;
import org.ballerinalang.auth.ldap.SslTrustConfig;
import org.ballerinalang.auth.ldap.util.LdapUtils;

public class SslTrustConfiguration {
    private SslTrustConfig sslTrustConfig = new SslTrustConfig();

    public void setTrustStoreFile(File trustStoreFile) {
        this.sslTrustConfig.setTrustStore(trustStoreFile);
    }

    public void setTrustStorePass(String trustStorePass) {
        this.sslTrustConfig.setTrustStorePass(trustStorePass);
    }

    public void setSSLProtocol(String sslProtocol) {
        this.sslTrustConfig.setSSLProtocol(sslProtocol);
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.sslTrustConfig.setTLSStoreType(tlsStoreType);
    }

    public void setClientTrustCertificates(String clientTrustCertificates) {
        this.sslTrustConfig.setClientTrustCertificates(new File(LdapUtils.substituteVariables(clientTrustCertificates)));
    }

    public SslTrustConfig getLdapSslConfiguration() {
        if ((this.sslTrustConfig.getTrustStore() == null || this.sslTrustConfig.getTrustStorePass() == null) && this.sslTrustConfig.getClientTrustCertificates() == null) {
            throw new IllegalArgumentException("TrustStoreFile or TrustStorePassword not defined for ldaps scheme");
        }
        if (this.sslTrustConfig.getTrustStore() != null) {
            if (!this.sslTrustConfig.getTrustStore().exists()) {
                throw new IllegalArgumentException("TrustStore File " + this.sslTrustConfig.getTrustStore() + " not found");
            }
            this.sslTrustConfig.setTrustStorePass(this.sslTrustConfig.getTrustStorePass());
        } else if (!this.sslTrustConfig.getClientTrustCertificates().exists()) {
            throw new IllegalArgumentException("Key file or server certificates file not found");
        }
        this.sslTrustConfig.setTrustStore(this.sslTrustConfig.getTrustStore()).setTrustStorePass(this.sslTrustConfig.getTrustStorePass());
        String sslProtocol = this.sslTrustConfig.getSSLProtocol() != null ? this.sslTrustConfig.getSSLProtocol() : "TLS";
        this.sslTrustConfig.setSSLProtocol(sslProtocol);
        String tlsStoreType = this.sslTrustConfig.getTLSStoreType() != null ? this.sslTrustConfig.getTLSStoreType() : "PKCS12";
        this.sslTrustConfig.setTLSStoreType(tlsStoreType);
        return this.sslTrustConfig;
    }
}

