/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.auth.ldap.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.auth.ldap.CommonLdapConfiguration;
import org.ballerinalang.auth.ldap.LdapConnectionContext;
import org.ballerinalang.auth.ldap.SslContextTrustManager;
import org.ballerinalang.auth.ldap.util.LdapUtils;
import org.ballerinalang.auth.ldap.util.SslUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="auth", functionName="initLdapConnectionContext", args={@Argument(name="ldapAuthStoreProvider", type=TypeKind.OBJECT, structType="LdapAuthStoreProvider"), @Argument(name="instanceId", type=TypeKind.STRING)}, isPublic=true)
public class InitLdapConnectionContext
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String instanceId = context.getStringArgument(0);
        BMap authStore = (BMap)context.getRefArgument(0);
        BMap configBStruct = (BMap)authStore.get((Object)"ldapAuthProviderConfig");
        Struct authProviderConfig = BLangConnectorSPIUtil.toStruct((BMap)configBStruct);
        CommonLdapConfiguration commonLdapConfiguration = new CommonLdapConfiguration();
        commonLdapConfiguration.setDomainName(authProviderConfig.getStringField("domainName"));
        commonLdapConfiguration.setConnectionURL(authProviderConfig.getStringField("connectionURL"));
        commonLdapConfiguration.setConnectionName(authProviderConfig.getStringField("connectionName"));
        commonLdapConfiguration.setConnectionPassword(authProviderConfig.getStringField("connectionPassword"));
        commonLdapConfiguration.setUserSearchBase(authProviderConfig.getStringField("userSearchBase"));
        commonLdapConfiguration.setUserEntryObjectClass(authProviderConfig.getStringField("userEntryObjectClass"));
        commonLdapConfiguration.setUserNameAttribute(authProviderConfig.getStringField("userNameAttribute"));
        commonLdapConfiguration.setUserNameSearchFilter(authProviderConfig.getStringField("userNameSearchFilter"));
        commonLdapConfiguration.setUserNameListFilter(authProviderConfig.getStringField("userNameListFilter"));
        commonLdapConfiguration.setGroupSearchBase(InitLdapConnectionContext.getAsStringList(authProviderConfig.getArrayField("groupSearchBase")));
        commonLdapConfiguration.setGroupEntryObjectClass(authProviderConfig.getStringField("groupEntryObjectClass"));
        commonLdapConfiguration.setGroupNameAttribute(authProviderConfig.getStringField("groupNameAttribute"));
        commonLdapConfiguration.setGroupNameSearchFilter(authProviderConfig.getStringField("groupNameSearchFilter"));
        commonLdapConfiguration.setGroupNameListFilter(authProviderConfig.getStringField("groupNameListFilter"));
        commonLdapConfiguration.setMembershipAttribute(authProviderConfig.getStringField("membershipAttribute"));
        commonLdapConfiguration.setUserRolesCacheEnabled(authProviderConfig.getBooleanField("userRolesCacheEnabled"));
        commonLdapConfiguration.setConnectionPoolingEnabled(authProviderConfig.getBooleanField("connectionPoolingEnabled"));
        commonLdapConfiguration.setLdapConnectionTimeout((int)authProviderConfig.getIntField("ldapConnectionTimeout"));
        commonLdapConfiguration.setReadTimeout((int)authProviderConfig.getIntField("readTimeout"));
        commonLdapConfiguration.setRetryAttempts((int)authProviderConfig.getIntField("retryAttempts"));
        Struct sslConfig = authProviderConfig.getStructField("secureClientSocket");
        try {
            if (sslConfig != null) {
                this.setSslConfig(sslConfig, commonLdapConfiguration, instanceId);
                LdapUtils.setServiceName(instanceId);
            }
            LdapConnectionContext connectionSource = new LdapConnectionContext(commonLdapConfiguration);
            DirContext dirContext = connectionSource.getContext();
            authStore.addNativeData("ldapConfiguration", (Object)commonLdapConfiguration);
            authStore.addNativeData("connectionSource", (Object)connectionSource);
            authStore.addNativeData("connectionContext", (Object)dirContext);
            authStore.addNativeData("instanceId", (Object)instanceId);
            context.setReturnValues(new BValue[0]);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException | NamingException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (sslConfig != null) {
                LdapUtils.removeServiceName();
            }
        }
    }

    private void setSslConfig(Struct sslConfig, CommonLdapConfiguration commonLdapConfiguration, String instanceId) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, CertificateException {
        Struct trustStore = sslConfig.getStructField("trustStore");
        String trustCerts = sslConfig.getStringField("trustedCertFile");
        if (trustStore != null) {
            String trustStoreFilePath = trustStore.getStringField("path");
            String trustStorePassword = trustStore.getStringField("password");
            if (trustStoreFilePath != null) {
                File trustStoreFile = new File(LdapUtils.substituteVariables(trustStoreFilePath));
                if (!trustStoreFile.exists()) {
                    throw new IllegalArgumentException("trustStore File " + trustStoreFilePath + " not found");
                }
                if (trustStorePassword == null) {
                    throw new IllegalArgumentException("trustStorePass is not defined for HTTPS scheme");
                }
                commonLdapConfiguration.setTrustStoreFile(trustStoreFile);
                commonLdapConfiguration.setTrustStorePass(trustStorePassword);
                SSLContext sslContext = SslUtils.createClientSslContext(trustStoreFilePath, trustStorePassword);
                SslContextTrustManager.getInstance().addSSLContext(instanceId, sslContext);
            }
        } else if (StringUtils.isNotBlank((CharSequence)trustCerts)) {
            commonLdapConfiguration.setClientTrustCertificates(trustCerts);
            SSLContext sslContext = SslUtils.getSslContextForCertificateFile(trustCerts);
            SslContextTrustManager.getInstance().addSSLContext(instanceId, sslContext);
        }
    }

    private static List<String> getAsStringList(Value[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Value val : values) {
            valuesList.add(val.getStringValue().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }
}

