/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.auth.ldap.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ballerinalang.auth.ldap.CommonLdapConfiguration;
import org.ballerinalang.auth.ldap.UserStoreException;
import org.ballerinalang.util.exceptions.BallerinaException;

public class LdapUtils {
    private static final Log LOG = LogFactory.getLog(LdapUtils.class);
    private static final Pattern systemVariableIdentifierPattern = Pattern.compile("\\$\\{([^}]*)}");
    private static final ThreadLocal<String> socketFactoryName = new ThreadLocal();

    public static boolean isNullOrEmptyAfterTrim(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String getNameInSpaceForUsernameFromLDAP(String userName, CommonLdapConfiguration ldapConfiguration, DirContext dirContext) throws UserStoreException, NamingException {
        String userSearchFilter = ldapConfiguration.getUserNameSearchFilter();
        userSearchFilter = userSearchFilter.replace("?", LdapUtils.escapeSpecialCharactersForFilter(userName));
        String searchBase = ldapConfiguration.getUserSearchBase();
        return LdapUtils.getNameInSpaceForUserName(userName, searchBase, userSearchFilter, dirContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNameInSpaceForUserName(String userName, String searchBase, String searchFilter, DirContext dirContext) throws UserStoreException, NamingException {
        if (userName == null) {
            throw new UserStoreException("userName value is null.");
        }
        String userDN = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            String[] searchBases;
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            for (String base : searchBases = searchBase.split("#")) {
                SearchResult userObj;
                answer = dirContext.search(LdapUtils.escapeDNForSearch(base), searchFilter, searchCtls);
                if (!answer.hasMore() || (userObj = answer.next()) == null) continue;
                userDN = userObj.getNameInNamespace();
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Name in space for " + userName + " is " + userDN));
            }
        }
        finally {
            LdapUtils.closeNamingEnumeration(answer);
        }
        return userDN;
    }

    public static Name escapeDNForSearch(String dn) throws InvalidNameException {
        return new CompositeName().add(dn);
    }

    public static void closeContext(DirContext dirContext) throws NamingException {
        if (dirContext != null) {
            dirContext.close();
        }
    }

    public static void closeNamingEnumeration(NamingEnumeration<?> namingEnumeration) throws NamingException {
        if (namingEnumeration != null) {
            namingEnumeration.close();
        }
    }

    public static String escapeSpecialCharactersForFilter(String dnPartial) {
        dnPartial = dnPartial.replace("\\*", "*");
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < dnPartial.length(); ++i) {
            char currentChar = dnPartial.charAt(i);
            switch (currentChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isLdapsUrl(String url) {
        return null != url && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("ldaps://");
    }

    public static String substituteVariables(String value) {
        Matcher matcher = systemVariableIdentifierPattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = LdapUtils.getSystemVariableValue(sysPropKey = matcher.group(1), null)) == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " is not specified");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getSystemVariableValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }

    public static String getInstanceIdFromThreadLocal() {
        String result = socketFactoryName.get();
        if (result == null) {
            throw new BallerinaException("Cannot infer the ssl context related to the service");
        }
        return result;
    }

    public static void setServiceName(String serviceName) {
        socketFactoryName.set(serviceName);
    }

    public static void removeServiceName() {
        socketFactoryName.remove();
    }
}

