/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.auth.ldap.nativeimpl;

import java.nio.charset.Charset;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ballerinalang.auth.ldap.CommonLdapConfiguration;
import org.ballerinalang.auth.ldap.LdapConnectionContext;
import org.ballerinalang.auth.ldap.UserStoreException;
import org.ballerinalang.auth.ldap.util.LdapUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="auth", functionName="LdapAuthStoreProvider.doAuthenticate", args={@Argument(name="username", type=TypeKind.STRING), @Argument(name="password", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.BOOLEAN)}, isPublic=true)
public class Authenticate
extends BlockingNativeCallableUnit {
    private static final Log LOG = LogFactory.getLog(Authenticate.class);
    private LdapConnectionContext connectionSource;
    private CommonLdapConfiguration ldapConfiguration;
    private DirContext ldapConnectionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Context context) {
        BMap authStore = (BMap)context.getRefArgument(0);
        String userName = context.getStringArgument(0);
        byte[] credential = context.getStringArgument(1).getBytes(Charset.forName("UTF-8"));
        this.connectionSource = (LdapConnectionContext)authStore.getNativeData("connectionSource");
        this.ldapConnectionContext = (DirContext)authStore.getNativeData("connectionContext");
        this.ldapConfiguration = (CommonLdapConfiguration)authStore.getNativeData("ldapConfiguration");
        LdapUtils.setServiceName((String)authStore.getNativeData("instanceId"));
        if (LdapUtils.isNullOrEmptyAfterTrim(userName)) {
            context.setReturnValues(new BValue[]{new BBoolean(false)});
            throw new BallerinaException("username or credential value is empty or null.");
        }
        try {
            String name;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating user " + userName));
            }
            if ((name = LdapUtils.getNameInSpaceForUsernameFromLDAP(userName.trim(), this.ldapConfiguration, this.ldapConnectionContext)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Authenticating with " + name));
                }
                boolean bValue = this.bindAsUser(name, credential);
                context.setReturnValues(new BValue[]{new BBoolean(bValue)});
            } else {
                context.setReturnValues(new BValue[]{new BBoolean(false)});
            }
        }
        catch (NamingException e) {
            LOG.error((Object)("Cannot bind user : " + userName), (Throwable)e);
            context.setReturnValues(new BValue[]{new BBoolean(false)});
        }
        catch (UserStoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            context.setReturnValues(new BValue[]{new BBoolean(false)});
        }
        finally {
            LdapUtils.removeServiceName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bindAsUser(String dn, byte[] credentials) throws NamingException {
        boolean isAuthenticated;
        LdapContext cxt = null;
        try {
            cxt = this.connectionSource.getContextWithCredentials(dn, credentials);
            isAuthenticated = true;
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(cxt);
            throw throwable;
        }
        LdapUtils.closeContext(cxt);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User: " + dn + " is authnticated: " + isAuthenticated));
        }
        return isAuthenticated;
    }
}

