/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.command;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.utils.BindgenUtils;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import picocli.CommandLine;

@CommandLine.Command(name="bindgen", description={"A CLI tool for generating Ballerina bindings for Java APIs."})
public class BindgenCommand
implements BLauncherCmd {
    private PrintStream outStream;
    private PrintStream outError;
    private Path targetOutputPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-cp", "--classpath"}, description={"One or more comma-delimited classpaths for obtaining the jar files required for\ngenerating the Ballerina bindings."})
    private String classPath;
    @CommandLine.Option(names={"-mvn", "--maven"}, description={"A maven dependency with colon delimited groupId, artifactId and version."})
    private String mavenDependency;
    @CommandLine.Option(names={"-o", "--output"}, description={"Location of the generated Ballerina bridge code."})
    private String outputPath;
    @CommandLine.Option(names={"--public"}, description={"Set the visibility modifier of Ballerina bindings to public."})
    private boolean publicFlag;
    @CommandLine.Parameters
    private List<String> classNames;
    private static final String BINDGEN_CMD = "ballerina bindgen [(-cp|--classpath) <classpath>...]\n                  [(-mvn|--maven) <groupId>:<artifactId>:<version>]\n                  [(-o|--output) <output>]\n                  [--public]\n                  (<class-name>...)";

    public BindgenCommand() {
        this(System.out, System.err);
    }

    public BindgenCommand(PrintStream out, PrintStream err) {
        this.outStream = out;
        this.outError = err;
        BindgenUtils.setOutStream(out);
        BindgenUtils.setErrStream(err);
    }

    public void execute() {
        this.outStream.println("\nNote: This is an experimental tool.");
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.classNames == null) {
            this.outError.println("\nOne or more class names should be specified to generate the Ballerina bindings.\n");
            this.outStream.println(BINDGEN_CMD);
            this.outStream.println("\nUse 'ballerina bindgen --help' for more information on the command.");
            return;
        }
        BindingsGenerator bindingsGenerator = new BindingsGenerator(this.outStream, this.outError);
        if (this.outputPath != null) {
            this.targetOutputPath = Paths.get(this.outputPath, new String[0]).isAbsolute() ? Paths.get(this.outputPath, new String[0]) : Paths.get(this.targetOutputPath.toString(), this.outputPath);
            BindingsGenerator.setOutputPath(this.outputPath);
        }
        if (this.publicFlag) {
            bindingsGenerator.setPublic();
        }
        if (!ProjectDirs.isProject((Path)this.targetOutputPath)) {
            Path findRoot = ProjectDirs.findProjectRoot((Path)this.targetOutputPath);
            if (findRoot != null) {
                this.outStream.println("\nBallerina project detected at: " + findRoot.toString());
                bindingsGenerator.setProjectRoot(findRoot);
            }
        } else {
            this.outStream.println("\nBallerina project detected at: " + this.targetOutputPath.toString());
            bindingsGenerator.setProjectRoot(this.targetOutputPath);
        }
        String splitCommaRegex = "\\s*,\\s*";
        if (this.classPath != null) {
            String[] dependencyList = this.classPath.split(splitCommaRegex);
            bindingsGenerator.setDependentJars(dependencyList);
        }
        String splitColonRegex = "\\s*:\\s*";
        if (this.mavenDependency != null) {
            String[] mvnDependency = this.mavenDependency.split(splitColonRegex);
            if (mvnDependency.length != 3) {
                this.outError.println("\nError in the maven dependency provided.\n");
                this.outStream.println(BINDGEN_CMD);
                this.outStream.println("\nUse 'ballerina bindgen --help' for more information on the command.");
                return;
            }
            bindingsGenerator.setMvnGroupId(mvnDependency[0]);
            bindingsGenerator.setMvnArtifactId(mvnDependency[1]);
            bindingsGenerator.setMvnVersion(mvnDependency[2]);
        }
        bindingsGenerator.setClassNames(this.classNames);
        try {
            bindingsGenerator.generateJavaBindings();
        }
        catch (BindgenException e) {
            this.outError.println("\nError while generating Ballerina bindings:\n" + e.getMessage());
        }
    }

    public String getName() {
        return "bindgen";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("A CLI tool for generating Ballerina bridge code for Java APIs. \n");
        out.append("\n");
        out.append("Ballerina bindings could be generated for Java classes residing inside Java libraries \n");
        out.append("or standard Java classes. Here, the Java classes will be mapped onto Ballerina");
        out.append("objects, making the developer experience of Ballerina Java interoperability seamless. \n");
        out.append("\n");
        out.append("The directly dependent Java classes and other required resources will be automatically \n");
        out.append("generated apart from the specified Java classes. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina bindgen java.utils.ArrayDeque\n");
        out.append("  ballerina bindgen -cp ./libs/snakeyaml-1.25.jar,./libs/pdfbox-1.8.10.jar   -o ./src/sample org.yaml.snakeyaml.Yaml org.apache.pdfbox.pdmodel.PDDocument java.io.File\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

