/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.command;

import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.tool.BLauncherCmd;
import picocli.CommandLine;

@CommandLine.Command(name="bindgen", description={"A CLI tool for generating Ballerina bindings for Java APIs."})
public class BindgenCommand
implements BLauncherCmd {
    private static final PrintStream outStream = System.out;
    private static final PrintStream outError = System.err;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-cp", "--classpath"}, description={"One or more comma-delimited classpaths for obtaining the jar files required for\ngenerating the Ballerina bindings."})
    private String classPath;
    @CommandLine.Option(names={"-o", "--output"}, description={"Location of the generated Ballerina bridge code."})
    private String outputPath;
    @CommandLine.Parameters
    private List<String> classNames;
    private static final String BINDGEN_CMD = "ballerina bindgen [(-cp|--classpath) <classpath>...]\n                  [(-o|--output) <output>]\n                  (<class-name>...)";

    public void execute() {
        outStream.println("\nNote: This is an experimental tool.\n");
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            outStream.println(commandUsageInfo);
            return;
        }
        if (this.classNames == null) {
            outError.println("One or more class names should be specified to generate the Ballerina bindings.\n");
            outStream.println(BINDGEN_CMD);
            outStream.println("\nUse 'ballerina bindgen --help' for more information on the command.");
            return;
        }
        BindingsGenerator bindingsGenerator = new BindingsGenerator();
        if (this.outputPath != null) {
            bindingsGenerator.setOutputPath(this.outputPath);
        }
        String splitCommaRegex = "\\s*,\\s*";
        if (this.classPath != null) {
            String[] dependencyList = this.classPath.split(splitCommaRegex);
            bindingsGenerator.setDependentJars(dependencyList);
        }
        bindingsGenerator.setClassNames(this.classNames);
        try {
            bindingsGenerator.generateJavaBindings();
        }
        catch (BindgenException e) {
            outError.println("\nError while generating Ballerina bindings:\n" + e.getMessage());
        }
    }

    public String getName() {
        return "bindgen";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("A CLI tool for generating Ballerina bridge code for Java APIs. \n");
        out.append("\n");
        out.append("Ballerina bindings could be generated for Java classes residing inside Java libraries \n");
        out.append("or standard Java classes. Here, the Java classes will be mapped onto Ballerina");
        out.append("objects, making the developer experience of Ballerina Java interoperability seamless. \n");
        out.append("\n");
        out.append("The directly dependent Java classes and other required resources will be automatically \n");
        out.append("generated apart from the specified Java classes. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina bindgen java.utils.ArrayDeque\n");
        out.append("  ballerina bindgen -cp ./libs/snakeyaml-1.25.jar,./libs/pdfbox-1.8.10.jar   -o ./src/sample org.yaml.snakeyaml.Yaml org.apache.pdfbox.pdmodel.PDDocument java.io.File\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

