/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.command;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class BindingsGenerator {
    private Path modulePath;
    private Path dependenciesPath;
    private Path utilsDirPath;
    private String outputPath;
    private Set<String> classPaths = new HashSet<String>();
    private Set<String> classNames = new HashSet<String>();
    private static boolean directJavaClass = true;
    private static final PrintStream errStream = System.err;
    private static final PrintStream outStream = System.out;
    private static Path userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
    private static Set<String> allClasses = new HashSet<String>();
    private static Set<String> classListForLooping = new HashSet<String>();
    private static Set<String> allJavaClasses = new HashSet<String>();
    private static Set<JError> exceptionList = new HashSet<JError>();
    private static Map<String, String> failedClassGens = new HashMap<String, String>();

    void generateJavaBindings() throws BindgenException {
        ClassLoader classLoader = this.setClassLoader();
        if (classLoader != null) {
            this.setDirectoryPaths();
            outStream.println("\nGenerating bindings for: ");
            this.generateBindings(this.classNames, classLoader, this.modulePath);
            if (!classListForLooping.isEmpty()) {
                outStream.println("\nGenerating dependency bindings for: ");
                BindingsGenerator.setDependentJavaClass();
            }
            while (!classListForLooping.isEmpty()) {
                HashSet<String> newSet = new HashSet<String>(classListForLooping);
                newSet.removeAll(this.classNames);
                List<String> existingBindings = BindgenUtils.getExistingBindings(newSet, this.modulePath.toFile());
                newSet.removeAll(existingBindings);
                allJavaClasses.addAll(newSet);
                classListForLooping.clear();
                this.generateBindings(newSet, classLoader, this.dependenciesPath);
            }
            this.generateUtilFiles();
            if (failedClassGens != null) {
                this.handleFailedClassGens();
            }
        }
    }

    private ClassLoader setClassLoader() throws BindgenException {
        ClassLoader classLoader;
        try {
            if (!this.classPaths.isEmpty()) {
                classLoader = BindgenUtils.getClassLoader(this.classPaths, this.getClass().getClassLoader());
            } else {
                outStream.println("No classpaths were detected.");
                classLoader = this.getClass().getClassLoader();
            }
        }
        catch (BindgenException e) {
            throw new BindgenException("Error while loading the classpaths.", e);
        }
        return classLoader;
    }

    private void setDirectoryPaths() {
        String userPath = userDir.toString();
        if (this.outputPath != null) {
            userPath = this.outputPath;
        }
        this.modulePath = Paths.get(userPath, "ballerina_bindings", "bindings");
        this.dependenciesPath = Paths.get(userPath, "ballerina_bindings", "dependencies");
        this.utilsDirPath = Paths.get(userPath, "ballerina_bindings", "utils");
    }

    private void handleFailedClassGens() throws BindgenException {
        errStream.print("\n");
        for (Map.Entry<String, String> entry : failedClassGens.entrySet()) {
            if (!this.classNames.contains(entry.getKey())) continue;
            errStream.println("Bindings for '" + entry.getKey() + "' class could not be generated.\n\t" + entry.getValue() + "\n");
        }
    }

    private void generateUtilFiles() throws BindgenException {
        BindgenUtils.createDirectory(this.utilsDirPath.toString());
        BindgenUtils.writeOutputFile(null, "/templates", "jobject", Paths.get(this.utilsDirPath.toString(), "JObject.bal").toString(), false);
        BindgenUtils.writeOutputFile(null, "/templates", "array_utils", Paths.get(this.utilsDirPath.toString(), "ArrayUtils.bal").toString(), false);
        Path constantsPath = Paths.get(this.utilsDirPath.toString(), "Constants.bal");
        HashSet<String> names = new HashSet<String>(allClasses);
        if (constantsPath.toFile().exists()) {
            BindgenUtils.getUpdatedConstantsList(constantsPath, names);
            BindgenUtils.notifyExistingDependencies(this.classNames, this.dependenciesPath.toFile());
        }
        if (!names.isEmpty()) {
            BindgenUtils.writeOutputFile(names, "/templates", "constants", constantsPath.toString(), true);
        }
        for (JError jError : exceptionList) {
            String fileName = jError.getShortExceptionName() + ".bal";
            BindgenUtils.writeOutputFile(jError, "/templates", "exception", Paths.get(this.utilsDirPath.toString(), fileName).toString(), false);
        }
    }

    void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    void setDependentJars(String[] jarPaths) {
        Collections.addAll(this.classPaths, jarPaths);
    }

    void setClassNames(List<String> classNames) {
        this.classNames = new HashSet<String>(classNames);
    }

    private void generateBindings(Set<String> classList, ClassLoader classLoader, Path modulePath) throws BindgenException {
        BindgenUtils.createDirectory(modulePath.toString());
        for (String c : classList) {
            try {
                Class<?> classInstance;
                if (classLoader == null || (classInstance = classLoader.loadClass(c)) == null || !BindgenUtils.isPublicClass(classInstance)) continue;
                JClass jClass = new JClass(classInstance);
                String outputFile = Paths.get(modulePath.toString(), jClass.getPackageName()).toString();
                BindgenUtils.createDirectory(outputFile);
                String filePath = Paths.get(outputFile, jClass.getShortClassName() + ".bal").toString();
                BindgenUtils.writeOutputFile(jClass, "/templates", "bridge_class", filePath, false);
                outStream.println("\t" + c);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                failedClassGens.put(c, e.toString());
            }
            catch (BindgenException e) {
                throw new BindgenException("Error while generating Ballerina bridge code: " + e);
            }
        }
    }

    public static boolean isDirectJavaClass() {
        return directJavaClass;
    }

    private static void setDependentJavaClass() {
        directJavaClass = false;
    }

    public static Set<String> getAllJavaClasses() {
        return allJavaClasses;
    }

    public static void setClassListForLooping(String classListForLooping) {
        BindingsGenerator.classListForLooping.add(classListForLooping);
    }

    public static void setAllClasses(String allClasses) {
        BindingsGenerator.allClasses.add(allClasses);
    }

    public static Set<JError> getExceptionList() {
        return exceptionList;
    }

    public static void setExceptionList(JError exception) {
        exceptionList.add(exception);
    }
}

