/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.model.JConstructor;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JClass {
    private String prefix;
    private String className;
    private String packageName;
    private String shortClassName;
    private boolean isInterface = false;
    private boolean isDirectClass = false;
    private boolean isAbstract = false;
    private boolean hasJavaModuleImport = false;
    private Set<String> superClasses = new HashSet<String>();
    private List<JField> fieldList = new ArrayList<JField>();
    private List<JMethod> methodList = new ArrayList<JMethod>();
    private List<JConstructor> constructorList = new ArrayList<JConstructor>();
    private List<JConstructor> initFunctionList = new ArrayList<JConstructor>();

    public JClass(Class c) {
        this.className = c.getName();
        this.prefix = this.className.replace(".", "_").replace("$", "_");
        this.shortClassName = c.getSimpleName();
        this.packageName = c.getPackage().getName();
        BindingsGenerator.setAllClasses(this.shortClassName);
        if (c.isInterface()) {
            this.isInterface = true;
            BindingsGenerator.setAllClasses(Object.class.getSimpleName());
            this.superClasses.add(Object.class.getSimpleName());
        }
        this.populateImplementedInterfaces(c.getInterfaces());
        for (Class sClass = c.getSuperclass(); sClass != null; sClass = sClass.getSuperclass()) {
            this.populateImplementedInterfaces(sClass.getInterfaces());
            String simpleClassName = sClass.getSimpleName().replace("$", "");
            this.superClasses.add(simpleClassName);
            BindingsGenerator.setAllClasses(simpleClassName);
        }
        if (BindgenUtils.isAbstractClass(c)) {
            this.isAbstract = true;
        }
        if (BindingsGenerator.isDirectJavaClass()) {
            this.isDirectClass = true;
            this.populateConstructors(c.getConstructors());
            this.populateInitFunctions();
            this.populateMethods(this.getMethods(c));
            this.methodList.sort(Comparator.comparing(JMethod::getParamTypes));
            BindgenUtils.handleOverloadedMethods(this.methodList);
            this.methodList.sort(Comparator.comparing(JMethod::getJavaMethodName));
            this.populateFields(c.getFields());
            if (!(this.methodList.isEmpty() && this.constructorList.isEmpty() && this.fieldList.isEmpty())) {
                this.hasJavaModuleImport = true;
            }
        }
    }

    private List<Method> getMethods(Class classObject) {
        Method[] declaredMethods = classObject.getMethods();
        ArrayList<Method> classMethods = new ArrayList<Method>();
        for (Method m : declaredMethods) {
            if (m.isSynthetic() || m.getName().equals("toString")) continue;
            classMethods.add(m);
        }
        return classMethods;
    }

    private void populateConstructors(Constructor[] constructors) {
        int i = 1;
        for (Constructor constructor : constructors) {
            JConstructor jConstructor = new JConstructor(constructor);
            this.constructorList.add(jConstructor);
        }
        this.constructorList.sort(Comparator.comparing(JConstructor::getParamTypes));
        for (JConstructor jConstructor : this.constructorList) {
            jConstructor.setConstructorName("new" + this.shortClassName + i);
            ++i;
        }
    }

    private void populateInitFunctions() {
        int j = 1;
        for (JConstructor constructor : this.constructorList) {
            JConstructor newCons = null;
            try {
                newCons = (JConstructor)constructor.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (newCons != null) {
                newCons.setExternalFunctionName(constructor.getConstructorName());
                newCons.setConstructorName("" + j);
                this.initFunctionList.add(newCons);
            }
            ++j;
        }
    }

    private void populateMethods(List<Method> declaredMethods) {
        for (Method method : declaredMethods) {
            if (!BindgenUtils.isPublicMethod(method)) continue;
            JMethod jMethod = new JMethod(method);
            this.methodList.add(jMethod);
        }
    }

    private void populateFields(Field[] fields) {
        for (Field field : fields) {
            this.fieldList.add(new JField(field, "access"));
            if (BindgenUtils.isFinalField(field) || !BindgenUtils.isPublicField(field)) continue;
            this.fieldList.add(new JField(field, "mutate"));
        }
    }

    private void populateImplementedInterfaces(Class[] interfaces) {
        for (Class interfaceClass : interfaces) {
            BindingsGenerator.setAllClasses(interfaceClass.getSimpleName());
            this.superClasses.add(interfaceClass.getSimpleName());
            if (interfaceClass.getInterfaces() == null) continue;
            this.populateImplementedInterfaces(interfaceClass.getInterfaces());
        }
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

