/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.model.JParameter;

public class JConstructor
implements Cloneable {
    private String interopType;
    private String exceptionName;
    private String shortClassName;
    private String initObjectName;
    private String constructorName;
    private String externalFunctionName;
    private boolean returnError = false;
    private boolean hasException = false;
    private boolean handleException = false;
    private List<JParameter> parameters = new ArrayList<JParameter>();
    private StringBuilder paramTypes = new StringBuilder();

    JConstructor(Constructor c) {
        this.shortClassName = c.getDeclaringClass().getSimpleName();
        this.constructorName = c.getName();
        this.interopType = "@java:Constructor";
        this.initObjectName = "_" + Character.toLowerCase(this.shortClassName.charAt(0)) + this.shortClassName.substring(1);
        for (Parameter parameter : c.getParameters()) {
            JParameter parameter2 = new JParameter(parameter);
            this.parameters.add(parameter2);
            this.paramTypes.append(parameter.getType().getSimpleName().toLowerCase(Locale.ENGLISH));
            if (!parameter2.getIsPrimitiveArray().booleanValue() && !parameter.getType().isArray()) continue;
            this.returnError = true;
            this.hasException = true;
        }
        if (!this.parameters.isEmpty()) {
            JParameter lastParam = this.parameters.get(this.parameters.size() - 1);
            lastParam.setHasNext(false);
        }
        for (AnnotatedElement annotatedElement : c.getExceptionTypes()) {
            try {
                if (this.getClass().getClassLoader().loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom((Class<?>)annotatedElement)) continue;
                JError jError = new JError((Class)annotatedElement);
                this.exceptionName = jError.getShortExceptionName();
                BindingsGenerator.setExceptionList(jError);
                this.hasException = true;
                this.handleException = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    void setConstructorName(String name) {
        this.constructorName = name;
    }

    void setExternalFunctionName(String name) {
        this.externalFunctionName = name;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getConstructorName() {
        return this.constructorName;
    }

    String getParamTypes() {
        return this.paramTypes.toString();
    }
}

