/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenConstants;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JMethod {
    private boolean isStatic;
    private boolean hasParams = true;
    private boolean hasReturn = false;
    private boolean returnError = false;
    private boolean isOverloaded = true;
    private boolean objectReturn = false;
    private boolean reservedWord = false;
    private boolean isArrayReturn = false;
    private boolean hasException = false;
    private boolean handleException = false;
    private boolean isStringReturn = false;
    private boolean hasPrimitiveParam = false;
    private boolean isStringArrayReturn = false;
    private String methodName;
    private String returnType;
    private String externalType;
    private String exceptionName;
    private String shortClassName;
    private String javaMethodName;
    private String returnComponentType;
    private String interopType = "@java:Method";
    private List<JParameter> parameters = new ArrayList<JParameter>();
    private StringBuilder paramTypes = new StringBuilder();

    JMethod(Method m) {
        this.javaMethodName = m.getName();
        this.methodName = m.getName();
        this.shortClassName = m.getDeclaringClass().getSimpleName();
        this.isStatic = BindgenUtils.isStaticMethod(m);
        Class<?> returnTypeClass = m.getReturnType();
        if (!returnTypeClass.equals(Void.TYPE)) {
            this.setReturnTypeAttributes(returnTypeClass);
        }
        for (Class<?> exceptionType : m.getExceptionTypes()) {
            try {
                if (this.getClass().getClassLoader().loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                JError jError = new JError(exceptionType);
                this.exceptionName = jError.getShortExceptionName();
                BindingsGenerator.setExceptionList(jError);
                this.hasException = true;
                this.handleException = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.setParameters(m.getParameters());
        if (!this.parameters.isEmpty()) {
            JParameter lastParam = this.parameters.get(this.parameters.size() - 1);
            lastParam.setHasNext(false);
        } else {
            this.hasParams = false;
        }
        List<String> reservedWords = Arrays.asList(BindgenConstants.BALLERINA_RESERVED_WORDS);
        if (reservedWords.contains(this.methodName)) {
            this.reservedWord = true;
        }
        if (this.objectReturn && !BindingsGenerator.getAllJavaClasses().contains(returnTypeClass.getName())) {
            if (this.isArrayReturn) {
                BindingsGenerator.setClassListForLooping(returnTypeClass.getComponentType().getName());
            } else {
                BindingsGenerator.setClassListForLooping(returnTypeClass.getName());
            }
        }
    }

    private void setReturnTypeAttributes(Class returnTypeClass) {
        this.hasReturn = true;
        this.externalType = BindgenUtils.getBallerinaHandleType(returnTypeClass);
        this.returnType = BindgenUtils.getBallerinaParamType(returnTypeClass);
        if (returnTypeClass.isArray()) {
            this.isArrayReturn = true;
            if (returnTypeClass.getComponentType().isPrimitive()) {
                this.objectReturn = false;
            } else if (returnTypeClass.getSimpleName().equals("String[]")) {
                this.objectReturn = true;
                this.isStringArrayReturn = true;
            } else {
                this.returnComponentType = returnTypeClass.getComponentType().getSimpleName();
                this.objectReturn = true;
            }
        } else if (returnTypeClass.isPrimitive()) {
            this.objectReturn = false;
        } else if (returnTypeClass.getSimpleName().equals("String")) {
            this.isStringReturn = true;
        } else {
            this.objectReturn = true;
        }
    }

    private void setParameters(Parameter[] paramArr) {
        for (Parameter param : paramArr) {
            this.paramTypes.append(param.getType().getSimpleName().toLowerCase(Locale.ENGLISH));
            JParameter parameter = new JParameter(param);
            this.parameters.add(parameter);
            if (parameter.getIsPrimitiveArray().booleanValue()) {
                this.returnError = true;
                this.hasPrimitiveParam = true;
                this.hasException = true;
            }
            if (!parameter.isObjArrayParam().booleanValue() && !parameter.getIsStringArray().booleanValue()) continue;
            this.returnError = true;
            this.hasException = true;
        }
    }

    String getJavaMethodName() {
        return this.javaMethodName;
    }

    String getParamTypes() {
        return this.paramTypes.toString();
    }

    public Boolean getHasReturn() {
        return this.hasReturn;
    }

    public Boolean getHasException() {
        return this.hasException;
    }

    public Boolean getIsStringReturn() {
        return this.isStringReturn;
    }

    public Boolean getHasPrimitiveParam() {
        return this.hasPrimitiveParam;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setIsOverloaded(boolean overloaded) {
        this.isOverloaded = overloaded;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<JParameter> getParameters() {
        return this.parameters;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean hasParams() {
        return this.hasParams;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public boolean isReturnError() {
        return this.returnError;
    }
}

