/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.utils;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.model.JParameter;

public class BindgenUtils {
    private static final PrintStream errStream = System.err;
    private static final PrintStream outStream = System.out;

    private BindgenUtils() {
    }

    public static void writeOutputFile(Object object, String templateDir, String templateName, String outPath, Boolean append) throws BindgenException {
        PrintWriter writer = null;
        FileWriterWithEncoding fileWriter = null;
        try {
            Template template = BindgenUtils.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
            fileWriter = new FileWriterWithEncoding(outPath, StandardCharsets.UTF_8, append.booleanValue());
            writer = new PrintWriter((Writer)fileWriter);
            writer.println(template.apply(context));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new BindgenException("Unable to create the Ballerina file: " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Template compileTemplate(String defaultTemplateDir, String templateName) throws BindgenException {
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.registerHelper("controlChars", (object, options) -> {
            if (object instanceof String) {
                return "'" + object;
            }
            return "";
        });
        handlebars.registerHelper("getSimpleName", (object, options) -> {
            if (object instanceof String) {
                String className = (String)object;
                return className.substring(className.lastIndexOf(46) + 1);
            }
            return object;
        });
        handlebars.registerHelper("getParams", (object, options) -> {
            String returnString = "";
            if (object instanceof JParameter) {
                JParameter param = (JParameter)object;
                returnString = BindgenUtils.getParamsHelper(param);
            }
            return returnString;
        });
        handlebars.registerHelper("getReturn", (object, options) -> {
            String returnString = "";
            if (object instanceof JMethod) {
                JMethod jMethod = (JMethod)object;
                returnString = BindgenUtils.getReturnHelper(jMethod);
            }
            return returnString;
        });
        handlebars.registerHelper("getInteropMethod", (object, options) -> {
            String returnString = "";
            if (object instanceof JMethod) {
                JMethod jMethod = (JMethod)object;
                String type = options.params[0].toString();
                if (type.equals("param")) {
                    returnString = BindgenUtils.getInteropMethodParam(jMethod);
                } else if (type.equals("return")) {
                    returnString = BindgenUtils.getInteropMethodReturn(jMethod);
                }
            }
            return returnString;
        });
        handlebars.registerHelper("getInteropFieldParam", (object, options) -> {
            String returnString = "";
            if (object instanceof JField) {
                JField jField = (JField)object;
                returnString = BindgenUtils.getInteropFieldParam(jField);
            }
            return returnString;
        });
        try {
            return handlebars.compile(templateName);
        }
        catch (FileNotFoundException e) {
            throw new BindgenException("Code generation template file does not exist: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BindgenException("Unable to read the " + templateName + " template file: " + e.getMessage(), e);
        }
    }

    private static String getInteropFieldParam(JField jField) {
        StringBuilder returnString = new StringBuilder();
        if (!jField.isStatic()) {
            returnString.append("handle receiver");
        }
        if (jField.isSetter()) {
            if (!jField.isStatic()) {
                returnString.append(", ");
            }
            returnString.append(jField.getExternalType()).append(" arg");
        }
        return returnString.toString();
    }

    private static String getInteropMethodReturn(JMethod jMethod) {
        StringBuilder returnString = new StringBuilder();
        if (jMethod.getHasReturn().booleanValue()) {
            returnString.append(" returns ").append(jMethod.getExternalType());
            if (jMethod.isHandleException()) {
                returnString.append("|error");
            }
        } else if (jMethod.isHandleException()) {
            returnString.append(" returns error?");
        }
        return returnString.toString();
    }

    private static String getInteropMethodParam(JMethod jMethod) {
        StringBuilder returnString = new StringBuilder();
        if (!jMethod.isStatic()) {
            returnString.append("handle receiver");
            if (jMethod.hasParams()) {
                returnString.append(", ");
            }
        }
        for (JParameter param : jMethod.getParameters()) {
            returnString.append(param.getExternalType()).append(" ").append(param.getFieldName());
            if (!param.getHasNext().booleanValue()) continue;
            returnString.append(", ");
        }
        return returnString.toString();
    }

    private static String getParamsHelper(JParameter param) {
        StringBuilder returnString = new StringBuilder();
        if (param.getIsObjArray().booleanValue()) {
            returnString.append("check getHandleFromArray(").append(param.getFieldName()).append(", \"").append(param.getComponentType()).append("\")");
        } else if (param.getIsPrimitiveArray().booleanValue()) {
            returnString.append("check getHandleFromArray(").append(param.getFieldName()).append(", \"").append(param.getComponentType()).append("\")");
        } else if (param.getIsString().booleanValue()) {
            returnString.append("java:fromString(").append(param.getFieldName()).append(")");
        } else if (param.getIsStringArray().booleanValue()) {
            returnString.append("check getHandleFromArray(").append(param.getFieldName()).append(", \"java.lang.String\")");
        } else {
            returnString.append(param.getFieldName());
            if (param.getIsObj().booleanValue()) {
                returnString.append(".jObj");
            }
        }
        if (param.getHasNext().booleanValue()) {
            returnString.append(", ");
        }
        return returnString.toString();
    }

    private static String getReturnHelper(JMethod jMethod) {
        StringBuilder returnString = new StringBuilder();
        if (jMethod.getHasReturn().booleanValue()) {
            returnString.append("returns ");
            returnString.append(jMethod.getReturnType());
            if (jMethod.getIsStringReturn().booleanValue()) {
                returnString.append("?");
            }
            if (jMethod.getHasException().booleanValue()) {
                if (jMethod.isHandleException()) {
                    returnString.append("|").append(jMethod.getExceptionName());
                    if (jMethod.isReturnError()) {
                        returnString.append("|error");
                    }
                } else {
                    returnString.append("|error");
                }
            }
            returnString.append(" ");
        } else if (jMethod.getHasException().booleanValue() || jMethod.getHasPrimitiveParam().booleanValue()) {
            returnString.append("returns error? ");
        }
        return returnString.toString();
    }

    private static void listAllFiles(String directoryName, List<File> files) {
        File directory = new File(directoryName);
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isFile()) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                BindgenUtils.listAllFiles(file.getAbsolutePath(), files);
            }
        }
    }

    public static void notifyExistingDependencies(Set<String> classList, File dependencyPath) {
        if (dependencyPath.isDirectory()) {
            ArrayList<File> listOfFiles = new ArrayList<File>();
            BindgenUtils.listAllFiles(dependencyPath.toString(), listOfFiles);
            if (listOfFiles.size() > 1) {
                for (String className : classList) {
                    for (File file : listOfFiles) {
                        String fileName = BindgenUtils.getDependencyFileName(className);
                        if (!file.getName().equals(fileName)) continue;
                        try {
                            Files.delete(file.toPath());
                            outStream.println("\nSuccessfully deleted the existing dependency: " + file.getPath());
                        }
                        catch (IOException e) {
                            errStream.println("\nFailed to delete the existing dependency: " + e.getMessage());
                        }
                    }
                }
            }
        }
    }

    public static List<String> getExistingBindings(Set<String> classList, File bindingsPath) {
        ArrayList<String> removeList = new ArrayList<String>();
        if (bindingsPath.isDirectory()) {
            ArrayList<File> listOfFiles = new ArrayList<File>();
            BindgenUtils.listAllFiles(bindingsPath.toString(), listOfFiles);
            if (listOfFiles.size() > 1) {
                block0: for (String className : classList) {
                    for (File file : listOfFiles) {
                        String fileName = BindgenUtils.getDependencyFileName(className);
                        if (!file.getName().equals(fileName)) continue;
                        removeList.add(className);
                        continue block0;
                    }
                }
            }
        }
        return removeList;
    }

    private static String getDependencyFileName(String className) {
        int prefix = className.contains("$") ? 36 : 46;
        return className.substring(className.lastIndexOf(prefix) + 1) + ".bal";
    }

    public static Set<String> getUpdatedConstantsList(Path existingPath, Set<String> classList) {
        try {
            List<String> allLines = Files.readAllLines(Paths.get(existingPath.toString(), new String[0]));
            ArrayList<String> removeList = new ArrayList<String>();
            block2: for (String className : classList) {
                for (String line : allLines) {
                    if (!line.contains("\"" + className + "\"")) continue;
                    removeList.add(className);
                    continue block2;
                }
            }
            classList.removeAll(removeList);
        }
        catch (IOException | ConcurrentModificationException e) {
            errStream.println("\nError while reading the existing constants file: " + e);
        }
        return classList;
    }

    public static void createDirectory(String path) throws BindgenException {
        File directory = new File(path);
        if (!directory.exists()) {
            try {
                boolean mkdirResult = directory.mkdirs();
                if (!mkdirResult) {
                    throw new BindgenException("Unable to create the directory: " + path);
                }
            }
            catch (SecurityException e) {
                throw new BindgenException("Unable to create the directory: " + path, e);
            }
        }
    }

    public static Set<String> getClassNamesInJar(String jarPath) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().replace("/", ".");
                classes.add(className.substring(0, className.length() - ".class".length()));
            }
            jarInputStream.close();
        }
        return classes;
    }

    public static boolean isPublicField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isPublicClass(Class javaClass) {
        int modifiers = javaClass.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public static boolean isStaticField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isStaticMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isFinalField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    public static boolean isAbstractClass(Class javaClass) {
        int modifiers = javaClass.getModifiers();
        return Modifier.isAbstract(modifiers) && !javaClass.isInterface();
    }

    public static String getModuleName(String jarPath) {
        Path jarName;
        String name = null;
        if (jarPath != null && (jarName = Paths.get(jarPath, new String[0]).getFileName()) != null) {
            name = jarName.toString().substring(0, jarName.toString().lastIndexOf(46));
            name = name.replace('-', '_');
        }
        return name;
    }

    public static void handleOverloadedMethods(List<JMethod> methodList) {
        HashMap<String, Integer> methodNames = new HashMap<String, Integer>();
        for (JMethod jMethod : methodList) {
            String mName = jMethod.getMethodName();
            if (methodNames.containsKey(mName)) {
                methodNames.replace(mName, (Integer)methodNames.get(mName) + 1);
                continue;
            }
            methodNames.put(mName, 1);
        }
        for (Map.Entry entry : methodNames.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            int i = 1;
            for (JMethod jMethod : methodList) {
                if (!jMethod.getMethodName().equals(entry.getKey())) continue;
                jMethod.setMethodName(jMethod.getMethodName() + i);
                jMethod.setIsOverloaded(true);
                ++i;
            }
        }
    }

    public static String getBallerinaParamType(Class javaType) {
        if (javaType.isArray() && javaType.getComponentType().isPrimitive()) {
            return BindgenUtils.getPrimitiveArrayBalType(javaType.getComponentType().getSimpleName());
        }
        String returnType = BindgenUtils.getBalType(javaType.getSimpleName());
        if (returnType.equals("handle")) {
            return javaType.getSimpleName();
        }
        return returnType;
    }

    public static String getBallerinaHandleType(Class javaType) {
        String type = javaType.getSimpleName();
        String returnType = BindgenUtils.getBalType(type);
        if (type.equals("String") || type.equals("String[]")) {
            returnType = "handle";
        }
        return returnType;
    }

    private static String getBalType(String type) {
        switch (type) {
            case "int": {
                return "int";
            }
            case "float": {
                return "float";
            }
            case "boolean": {
                return "boolean";
            }
            case "byte": {
                return "byte";
            }
            case "short": {
                return "int";
            }
            case "char": {
                return "int";
            }
            case "double": {
                return "float";
            }
            case "long": {
                return "int";
            }
            case "String": {
                return "string";
            }
            case "String[]": {
                return "string[]";
            }
        }
        return "handle";
    }

    private static String getPrimitiveArrayBalType(String type) {
        switch (type) {
            case "int": {
                return "int[]";
            }
            case "float": {
                return "float[]";
            }
            case "boolean": {
                return "boolean[]";
            }
            case "byte": {
                return "byte[]";
            }
            case "short": {
                return "int[]";
            }
            case "char": {
                return "int[]";
            }
            case "double": {
                return "float[]";
            }
            case "long": {
                return "int[]";
            }
        }
        return "handle";
    }

    public static String getPrimitiveArrayType(String type) {
        switch (type) {
            case "[C": 
            case "[S": 
            case "[J": {
                return "int[]";
            }
            case "[D": {
                return "float[]";
            }
            case "[B": {
                return "byte[]";
            }
            case "[I": {
                return "int[]";
            }
            case "[F": {
                return "float[]";
            }
            case "[Z": {
                return "boolean[]";
            }
        }
        return type;
    }

    public static URLClassLoader getClassLoader(Set<String> jarPaths, ClassLoader parent) throws BindgenException {
        URLClassLoader classLoader;
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            ArrayList<String> classPaths = new ArrayList<String>();
            for (String path : jarPaths) {
                File file = FileSystems.getDefault().getPath(path, new String[0]).toFile();
                if (file.isDirectory()) {
                    File[] paths = file.listFiles();
                    if (paths == null) continue;
                    for (File filePath : paths) {
                        if (!BindgenUtils.isJarFile(filePath)) continue;
                        urls.add(filePath.toURI().toURL());
                        classPaths.add(filePath.getName());
                    }
                    continue;
                }
                if (!BindgenUtils.isJarFile(file)) continue;
                urls.add(file.toURI().toURL());
                classPaths.add(file.getName());
            }
            if (!classPaths.isEmpty()) {
                outStream.println("Following jars were added to the classpath:");
                for (String path : classPaths) {
                    outStream.println("\t" + path);
                }
            } else {
                errStream.println("Failed to add the provided jars to classpath.");
            }
            classLoader = (URLClassLoader)AccessController.doPrivileged(() -> new URLClassLoader(urls.toArray(new URL[urls.size()]), parent));
        }
        catch (Exception e) {
            throw new BindgenException("Error while processing the classpaths.", e);
        }
        return classLoader;
    }

    private static boolean isJarFile(File file) {
        String fileName = file.getName();
        return file.isFile() && fileName.substring(fileName.lastIndexOf(46)).equals(".jar");
    }
}

