/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.bindgen.model.JParameter;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JField {
    private String fieldName;
    private String fieldType;
    private String interopType;
    private String externalType;
    private String returnTypeJava;
    private String fieldMethodName;
    private boolean isArray;
    private boolean isStatic;
    private boolean isString;
    private boolean isObject = true;
    private boolean isSetter = false;
    private boolean returnError = false;
    private boolean javaArraysModule = false;
    private JParameter fieldObj;

    JField(Field field, String fieldKind) {
        Class<?> type = field.getType();
        this.fieldType = BindgenUtils.getBallerinaParamType(type);
        this.externalType = BindgenUtils.getBallerinaHandleType(type);
        this.isStatic = BindgenUtils.isStaticField(field);
        this.fieldName = field.getName();
        this.fieldObj = new JParameter(type);
        this.fieldObj.setHasNext(false);
        if (type.isPrimitive() || type.equals(String.class)) {
            this.isObject = false;
        }
        if (this.fieldType.equals("string")) {
            this.isString = true;
        }
        if (type.isArray()) {
            this.isArray = true;
            this.returnError = true;
            if (!type.getComponentType().isPrimitive()) {
                this.isObject = false;
            }
            this.javaArraysModule = true;
        }
        if (fieldKind.equals("access")) {
            this.fieldMethodName = "get" + StringUtils.capitalize((String)this.fieldName);
            this.interopType = "@java:FieldGet";
            this.returnTypeJava = BindgenUtils.getJavaType(type);
        } else if (fieldKind.equals("mutate")) {
            this.fieldMethodName = "set" + StringUtils.capitalize((String)this.fieldName);
            this.interopType = "@java:FieldSet";
            this.isSetter = true;
        }
    }

    public boolean isString() {
        return this.isString;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSetter() {
        return this.isSetter;
    }

    String getFieldName() {
        return this.fieldName;
    }

    boolean requireJavaArrays() {
        return this.javaArraysModule;
    }
}

