/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.actions.data.sql;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.actions.data.sql.client.SQLDatasourceUtils;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SQLDataIterator
implements DataIterator {
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;
    private Calendar utcCalendar;
    private List<ColumnDefinition> columnDefs;
    private BStructType bStructType;

    public SQLDataIterator(Connection conn, Statement stmt, ResultSet rs, Calendar utcCalendar, List<ColumnDefinition> columnDefs) throws SQLException {
        this.conn = conn;
        this.stmt = stmt;
        this.rs = rs;
        this.utcCalendar = utcCalendar;
        this.columnDefs = columnDefs;
        this.generateStructType();
    }

    public void close(boolean isInTransaction) {
        SQLDatasourceUtils.cleanupConnection(this.rs, this.stmt, this.conn, isInTransaction);
        this.rs = null;
        this.stmt = null;
        this.conn = null;
    }

    public boolean next() {
        if (this.rs == null) {
            return false;
        }
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public String getString(String columnName) {
        try {
            return this.rs.getString(columnName);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public long getInt(String columnName) {
        try {
            return this.rs.getLong(columnName);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public double getFloat(String columnName) {
        try {
            return this.rs.getDouble(columnName);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean getBoolean(String columnName) {
        try {
            return this.rs.getBoolean(columnName);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public String getBlob(String columnName) {
        try {
            Blob bValue = this.rs.getBlob(columnName);
            return SQLDatasourceUtils.getString(bValue);
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> getArray(String columnName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Array array = this.rs.getArray(columnName);
            if (!this.rs.wasNull()) {
                Object[] objArray = (Object[])array.getArray();
                for (int i = 0; i < objArray.length; ++i) {
                    resultMap.put(String.valueOf(i), objArray[i]);
                }
            }
        }
        catch (SQLException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    public BStruct generateNext() {
        BStruct bStruct = new BStruct(this.bStructType);
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int blobRegIndex = -1;
        int refRegIndex = -1;
        try {
            block20: for (ColumnDefinition columnDef : this.columnDefs) {
                if (!(columnDef instanceof SQLColumnDefinition)) continue;
                SQLColumnDefinition def = (SQLColumnDefinition)columnDef;
                String columnName = def.getName();
                int sqlType = def.getSqlType();
                switch (sqlType) {
                    case 2003: {
                        BMap<String, BValue> bMapvalue = this.getDataArray(columnName);
                        bStruct.setRefField(++refRegIndex, bMapvalue);
                        continue block20;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        String sValue = this.rs.getString(columnName);
                        bStruct.setStringField(++stringRegIndex, sValue);
                        continue block20;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        Blob value = this.rs.getBlob(columnName);
                        if (value != null) {
                            bStruct.setBlobField(++blobRegIndex, value.getBytes(1L, (int)value.length()));
                            continue block20;
                        }
                        bStruct.setBlobField(++blobRegIndex, new byte[0]);
                        continue block20;
                    }
                    case 2005: {
                        String clobValue = SQLDatasourceUtils.getString(this.rs.getClob(columnName));
                        bStruct.setStringField(++stringRegIndex, clobValue);
                        continue block20;
                    }
                    case 2011: {
                        String nClobValue = SQLDatasourceUtils.getString(this.rs.getNClob(columnName));
                        bStruct.setStringField(++stringRegIndex, nClobValue);
                        continue block20;
                    }
                    case 91: {
                        String dateValue = SQLDatasourceUtils.getString(this.rs.getDate(columnName));
                        bStruct.setStringField(++stringRegIndex, dateValue);
                        continue block20;
                    }
                    case 92: 
                    case 2013: {
                        String timeValue = SQLDatasourceUtils.getString(this.rs.getTime(columnName, this.utcCalendar));
                        bStruct.setStringField(++stringRegIndex, timeValue);
                        continue block20;
                    }
                    case 93: 
                    case 2014: {
                        String timestmpValue = SQLDatasourceUtils.getString(this.rs.getTimestamp(columnName, this.utcCalendar));
                        bStruct.setStringField(++stringRegIndex, timestmpValue);
                        continue block20;
                    }
                    case -8: {
                        BString strValue = new BString(new String(this.rs.getRowId(columnName).getBytes(), "UTF-8"));
                        bStruct.setStringField(++stringRegIndex, strValue.stringValue());
                        continue block20;
                    }
                    case -6: 
                    case 5: {
                        long iValue = this.rs.getInt(columnName);
                        bStruct.setIntField(++longRegIndex, iValue);
                        continue block20;
                    }
                    case -5: 
                    case 4: {
                        long lValue = this.rs.getLong(columnName);
                        bStruct.setIntField(++longRegIndex, lValue);
                        continue block20;
                    }
                    case 6: 
                    case 7: {
                        double fValue = this.rs.getFloat(columnName);
                        bStruct.setFloatField(++doubleRegIndex, fValue);
                        continue block20;
                    }
                    case 8: {
                        double dValue = this.rs.getDouble(columnName);
                        bStruct.setFloatField(++doubleRegIndex, dValue);
                        continue block20;
                    }
                    case 2: 
                    case 3: {
                        double decimalValue = 0.0;
                        BigDecimal bigDecimalValue = this.rs.getBigDecimal(columnName);
                        if (bigDecimalValue != null) {
                            decimalValue = bigDecimalValue.doubleValue();
                        }
                        bStruct.setFloatField(++doubleRegIndex, decimalValue);
                        continue block20;
                    }
                    case -7: 
                    case 16: {
                        boolean boolValue = this.rs.getBoolean(columnName);
                        bStruct.setBooleanField(++booleanRegIndex, boolValue ? 1 : 0);
                        continue block20;
                    }
                }
                throw new BallerinaException("unsupported sql type " + sqlType + " found for the column " + columnName);
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in retrieving next value: " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaException("error in retrieving next value for rowid type: " + e.getCause().getMessage());
        }
        return bStruct;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefs;
    }

    private BMap<String, BValue> getDataArray(String columnName) {
        Map<String, Object> arrayMap = this.getArray(columnName);
        BMap returnMap = new BMap();
        if (!arrayMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : arrayMap.entrySet()) {
                String key = entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof String) {
                    returnMap.put((Object)key, (BValue)new BString(String.valueOf(obj)));
                    continue;
                }
                if (obj instanceof Boolean) {
                    returnMap.put((Object)key, (BValue)new BBoolean(Boolean.valueOf(obj.toString()).booleanValue()));
                    continue;
                }
                if (obj instanceof Integer) {
                    returnMap.put((Object)key, (BValue)new BInteger((long)Integer.parseInt(obj.toString())));
                    continue;
                }
                if (obj instanceof Long) {
                    returnMap.put((Object)key, (BValue)new BInteger(Long.parseLong(obj.toString())));
                    continue;
                }
                if (obj instanceof Float) {
                    returnMap.put((Object)key, (BValue)new BFloat((double)Float.parseFloat(obj.toString())));
                    continue;
                }
                if (!(obj instanceof Double)) continue;
                returnMap.put((Object)key, (BValue)new BFloat(Double.parseDouble(obj.toString())));
            }
        }
        return returnMap;
    }

    private void generateStructType() {
        BType[] structTypes = new BType[this.columnDefs.size()];
        BStructType.StructField[] structFields = new BStructType.StructField[this.columnDefs.size()];
        int typeIndex = 0;
        for (ColumnDefinition columnDef : this.columnDefs) {
            BType type;
            switch (columnDef.getType()) {
                case ARRAY: {
                    type = BTypes.typeMap;
                    break;
                }
                case STRING: {
                    type = BTypes.typeString;
                    break;
                }
                case BLOB: {
                    type = BTypes.typeBlob;
                    break;
                }
                case INT: {
                    type = BTypes.typeInt;
                    break;
                }
                case FLOAT: {
                    type = BTypes.typeFloat;
                    break;
                }
                case BOOLEAN: {
                    type = BTypes.typeBoolean;
                    break;
                }
                default: {
                    type = BTypes.typeNull;
                }
            }
            structTypes[typeIndex] = type;
            structFields[typeIndex] = new BStructType.StructField(type, columnDef.getName());
            ++typeIndex;
        }
        int[] fieldCount = SQLDataIterator.populateMaxSizes(structTypes);
        this.bStructType = new BStructType("RS", null);
        this.bStructType.setStructFields(structFields);
        this.bStructType.setFieldTypeCount(fieldCount);
    }

    private static int[] populateMaxSizes(BType[] paramTypes) {
        int[] maxSizes = new int[6];
        block7: for (int i = 0; i < paramTypes.length; ++i) {
            BType paramType = paramTypes[i];
            switch (paramType.getTag()) {
                case 1: {
                    maxSizes[0] = maxSizes[0] + 1;
                    continue block7;
                }
                case 2: {
                    maxSizes[1] = maxSizes[1] + 1;
                    continue block7;
                }
                case 3: {
                    maxSizes[2] = maxSizes[2] + 1;
                    continue block7;
                }
                case 4: {
                    maxSizes[3] = maxSizes[3] + 1;
                    continue block7;
                }
                case 5: {
                    maxSizes[4] = maxSizes[4] + 1;
                    continue block7;
                }
                default: {
                    maxSizes[5] = maxSizes[5] + 1;
                }
            }
        }
        return maxSizes;
    }

    public static class SQLColumnDefinition
    extends ColumnDefinition {
        private int sqlType;

        public SQLColumnDefinition(String name, TypeKind mappedType, int sqlType) {
            super(name, mappedType);
            this.sqlType = sqlType;
        }

        public String getName() {
            return this.name;
        }

        public TypeKind getType() {
            return this.mappedType;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }
}

