/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.actions.data.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.sql.XADataSource;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SQLDatasource
implements BValue {
    private HikariDataSource hikariDataSource;
    private String databaseName;
    private String connectorId;
    private boolean xaConn;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean init(BStruct options, String dbType, String hostOrPath, int port, String username, String password, String dbName) {
        this.buildDataSource(options, dbType, hostOrPath, dbName, port, username, password);
        this.connectorId = UUID.randomUUID().toString();
        this.xaConn = this.isXADataSource();
        try (Connection con = this.getSQLConnection();){
            this.databaseName = con.getMetaData().getDatabaseProductName().toLowerCase(Locale.ENGLISH);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in get connection: ClientConnector: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public Connection getSQLConnection() {
        try {
            return this.hikariDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BallerinaException("error in get connection: ClientConnector: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public boolean isXAConnection() {
        return this.xaConn;
    }

    public XADataSource getXADataSource() {
        XADataSource xaDataSource;
        try {
            xaDataSource = (XADataSource)this.hikariDataSource.unwrap(XADataSource.class);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in get distributed data source");
        }
        return xaDataSource;
    }

    public void closeConnectionPool() {
        this.hikariDataSource.close();
    }

    private void buildDataSource(BStruct options, String dbType, String hostOrPath, String dbName, int port, String username, String password) {
        try {
            HikariConfig config = new HikariConfig();
            config.setUsername(username);
            config.setPassword(password);
            if (options != null) {
                long leakDetectionThreshold;
                long validationTimeout;
                long maxLifetime;
                int minimumIdle;
                long idleTimeout;
                long connectionTimeout;
                int maximumPoolSize;
                String transactionIsolation;
                String driverClassName;
                String connectionInitSQL;
                String catalog;
                String poolName;
                boolean isXA = options.getBooleanField(4) != 0;
                BMap<String, BRefType> dataSourceConfigMap = (BMap<String, BRefType>)options.getRefField(0);
                String jdbcurl = options.getStringField(0);
                String dataSourceClassName = options.getStringField(1);
                if (!dataSourceClassName.isEmpty()) {
                    config.setDataSourceClassName(dataSourceClassName);
                    dataSourceConfigMap = this.setDataSourceProperties(dataSourceConfigMap, jdbcurl, username, password, dbType, hostOrPath, port, dbName);
                } else {
                    if (jdbcurl.isEmpty()) {
                        jdbcurl = this.constructJDBCURL(dbType, hostOrPath, port, dbName, username, password);
                    }
                    config.setJdbcUrl(jdbcurl);
                    if (isXA) {
                        String datasourceClassName = this.getXADatasourceClassName(dbType, jdbcurl, username, password);
                        config.setDataSourceClassName(datasourceClassName);
                        dataSourceConfigMap = this.setDataSourceProperties(dataSourceConfigMap, jdbcurl, username, password, dbType, hostOrPath, port, dbName);
                    }
                }
                String connectionTestQuery = options.getStringField(2);
                if (!connectionTestQuery.isEmpty()) {
                    config.setConnectionTestQuery(connectionTestQuery);
                }
                if (!(poolName = options.getStringField(3)).isEmpty()) {
                    config.setPoolName(poolName);
                }
                if (!(catalog = options.getStringField(4)).isEmpty()) {
                    config.setCatalog(catalog);
                }
                if (!(connectionInitSQL = options.getStringField(5)).isEmpty()) {
                    config.setConnectionInitSql(connectionInitSQL);
                }
                if (!(driverClassName = options.getStringField(6)).isEmpty()) {
                    config.setDriverClassName(driverClassName);
                }
                if (!(transactionIsolation = options.getStringField(7)).isEmpty()) {
                    config.setTransactionIsolation(transactionIsolation);
                }
                if ((maximumPoolSize = (int)options.getIntField(0)) != -1) {
                    config.setMaximumPoolSize(maximumPoolSize);
                }
                if ((connectionTimeout = options.getIntField(1)) != -1L) {
                    config.setConnectionTimeout(connectionTimeout);
                }
                if ((idleTimeout = options.getIntField(2)) != -1L) {
                    config.setIdleTimeout(idleTimeout);
                }
                if ((minimumIdle = (int)options.getIntField(3)) != -1) {
                    config.setMinimumIdle(minimumIdle);
                }
                if ((maxLifetime = options.getIntField(4)) != -1L) {
                    config.setMaxLifetime(maxLifetime);
                }
                if ((validationTimeout = options.getIntField(5)) != -1L) {
                    config.setValidationTimeout(validationTimeout);
                }
                if ((leakDetectionThreshold = options.getIntField(6)) != -1L) {
                    config.setLeakDetectionThreshold(leakDetectionThreshold);
                }
                boolean autoCommit = options.getBooleanField(0) != 0;
                config.setAutoCommit(autoCommit);
                boolean isolateInternalQueries = options.getBooleanField(1) != 0;
                config.setIsolateInternalQueries(isolateInternalQueries);
                boolean allowPoolSuspension = options.getBooleanField(2) != 0;
                config.setAllowPoolSuspension(allowPoolSuspension);
                boolean readOnly = options.getBooleanField(3) != 0;
                config.setReadOnly(readOnly);
                if (dataSourceConfigMap != null) {
                    this.setDataSourceProperties(dataSourceConfigMap, config);
                }
            } else {
                String jdbcurl = this.constructJDBCURL(dbType, hostOrPath, port, dbName, username, password);
                config.setJdbcUrl(jdbcurl);
            }
            this.hikariDataSource = new HikariDataSource(config);
        }
        catch (Throwable t) {
            String errorMessage = "error in sql connector configuration";
            throw new BallerinaException(errorMessage + ": " + t.getMessage());
        }
    }

    private BMap<String, BRefType> setDataSourceProperties(BMap<String, BRefType> dataSourceConfigMap, String jdbcurl, String username, String password, String dbType, String hostOrPath, int port, String dbName) {
        if (dataSourceConfigMap != null) {
            if (dataSourceConfigMap.get((Object)"url") == null) {
                if (jdbcurl.isEmpty()) {
                    jdbcurl = this.constructJDBCURL(dbType, hostOrPath, port, dbName, username, password);
                }
                dataSourceConfigMap.put((Object)"url", (BValue)new BString(jdbcurl));
            }
        } else {
            dataSourceConfigMap = new BMap();
            if (jdbcurl.isEmpty()) {
                jdbcurl = this.constructJDBCURL(dbType, hostOrPath, port, dbName, username, password);
            }
            dataSourceConfigMap.put((Object)"url", (BValue)new BString(jdbcurl));
        }
        dataSourceConfigMap.put((Object)"user", (BValue)new BString(username));
        dataSourceConfigMap.put((Object)"password", (BValue)new BString(password));
        return dataSourceConfigMap;
    }

    private String constructJDBCURL(String dbType, String hostOrPath, int port, String dbName, String username, String password) {
        StringBuilder jdbcUrl = new StringBuilder();
        dbType = dbType.toUpperCase(Locale.ENGLISH);
        hostOrPath = hostOrPath.replaceAll("/$", "");
        switch (dbType) {
            case "MYSQL": {
                if (port <= 0) {
                    port = 3306;
                }
                jdbcUrl.append("jdbc:mysql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "SQLSERVER": {
                if (port <= 0) {
                    port = 1433;
                }
                jdbcUrl.append("jdbc:sqlserver://").append(hostOrPath).append(":").append(port).append(";databaseName=").append(dbName);
                break;
            }
            case "ORACLE": {
                if (port <= 0) {
                    port = 1521;
                }
                jdbcUrl.append("jdbc:oracle:thin:").append(username).append("/").append(password).append("@").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "SYBASE": {
                if (port <= 0) {
                    port = 5000;
                }
                jdbcUrl.append("jdbc:sybase:Tds:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "POSTGRE": {
                if (port <= 0) {
                    port = 5432;
                }
                jdbcUrl.append("jdbc:postgresql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "IBMDB2": {
                if (port <= 0) {
                    port = 50000;
                }
                jdbcUrl.append("jdbc:db2:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "HSQLDB_SERVER": {
                if (port <= 0) {
                    port = 9001;
                }
                jdbcUrl.append("jdbc:hsqldb:hsql://").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "HSQLDB_FILE": {
                jdbcUrl.append("jdbc:hsqldb:file:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            case "H2_SERVER": {
                if (port <= 0) {
                    port = 9092;
                }
                jdbcUrl.append("jdbc:h2:tcp:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "H2_FILE": {
                jdbcUrl.append("jdbc:h2:file:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            case "DERBY_SERVER": {
                if (port <= 0) {
                    port = 1527;
                }
                jdbcUrl.append("jdbc:derby:").append(hostOrPath).append(":").append(port).append("/").append(dbName);
                break;
            }
            case "DERBY_FILE": {
                jdbcUrl.append("jdbc:derby:").append(hostOrPath).append(File.separator).append(dbName);
                break;
            }
            default: {
                throw new BallerinaException("cannot generate url for unknown database type : " + dbType);
            }
        }
        return jdbcUrl.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String getXADatasourceClassName(String dbType, String url, String userName, String password) {
        xaDataSource = null;
        var6_6 = dbType;
        var7_7 = -1;
        switch (var6_6.hashCode()) {
            case 73844866: {
                if (!var6_6.equals("MYSQL")) break;
                var7_7 = 0;
                break;
            }
            case 912124529: {
                if (!var6_6.equals("SQLSERVER")) break;
                var7_7 = 1;
                break;
            }
            case -1955532418: {
                if (!var6_6.equals("ORACLE")) break;
                var7_7 = 2;
                break;
            }
            case -1834523081: {
                if (!var6_6.equals("SYBASE")) break;
                var7_7 = 3;
                break;
            }
            case 326778906: {
                if (!var6_6.equals("POSTGRE")) break;
                var7_7 = 4;
                break;
            }
            case -2141725536: {
                if (!var6_6.equals("IBMDB2")) break;
                var7_7 = 5;
                break;
            }
            case -1831025538: {
                if (!var6_6.equals("HSQLDB_SERVER")) break;
                var7_7 = 6;
                break;
            }
            case 1472569719: {
                if (!var6_6.equals("HSQLDB_FILE")) break;
                var7_7 = 7;
                break;
            }
            case 809442360: {
                if (!var6_6.equals("H2_SERVER")) break;
                var7_7 = 8;
                break;
            }
            case 997105585: {
                if (!var6_6.equals("H2_FILE")) break;
                var7_7 = 9;
                break;
            }
            case -162746534: {
                if (!var6_6.equals("DERBY_SERVER")) break;
                var7_7 = 10;
                break;
            }
            case 1621791571: {
                if (!var6_6.equals("DERBY_FILE")) break;
                var7_7 = 11;
            }
        }
        switch (var7_7) {
            case 0: {
                try {
                    conn = DriverManager.getConnection(url, userName, password);
                    var10_10 = null;
                    driverMajorVersion = conn.getMetaData().getDriverMajorVersion();
                    if (driverMajorVersion == 5) {
                        xaDataSource = "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource";
                    } else if (driverMajorVersion > 5) {
                        xaDataSource = "com.mysql.cj.jdbc.MysqlXADataSource";
                    }
                    if (conn == null) break;
                    if (var10_10 == null) ** GOTO lbl72
                    try {
                        conn.close();
                    }
                    catch (Throwable var11_12) {
                        var10_10.addSuppressed(var11_12);
                    }
                    break;
lbl72:
                    // 1 sources

                    conn.close();
                    ** break;
                    catch (Throwable var11_13) {
                        try {
                            var10_10 = var11_13;
                            throw var11_13;
                        }
                        catch (Throwable var12_14) {
                            if (conn != null) {
                                if (var10_10 != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable var13_15) {
                                        var10_10.addSuppressed(var13_15);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                            throw var12_14;
lbl89:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BallerinaException("error in get connection: ClientConnector: " + e.getMessage(), (Throwable)e);
                }
            }
            case 1: {
                xaDataSource = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
                break;
            }
            case 2: {
                xaDataSource = "oracle.jdbc.xa.client.OracleXADataSource";
                break;
            }
            case 3: {
                xaDataSource = "com.sybase.jdbc3.jdbc.SybXADataSource";
                break;
            }
            case 4: {
                xaDataSource = "org.postgresql.xa.PGXADataSource";
                break;
            }
            case 5: {
                xaDataSource = "com.ibm.db2.jdbc.DB2XADataSource";
                break;
            }
            case 6: 
            case 7: {
                xaDataSource = "org.hsqldb.jdbc.pool.JDBCXADataSource";
                break;
            }
            case 8: 
            case 9: {
                xaDataSource = "org.h2.jdbcx.JdbcDataSource";
                break;
            }
            case 10: {
                xaDataSource = "org.apache.derby.jdbc.ClientXADataSource";
                break;
            }
            case 11: {
                xaDataSource = "org.apache.derby.jdbc.EmbeddedXADataSource";
                break;
            }
            default: {
                throw new BallerinaException("unknown database type used for xa connection : " + dbType);
            }
        }
        return xaDataSource;
    }

    private void setDataSourceProperties(BMap options, HikariConfig config) {
        Set keySet = options.keySet();
        for (String key : keySet) {
            BValue value = options.get((Object)key);
            if (value instanceof BString) {
                config.addDataSourceProperty(key, (Object)value.stringValue());
                continue;
            }
            if (value instanceof BInteger) {
                config.addDataSourceProperty(key, (Object)((BInteger)value).intValue());
                continue;
            }
            if (value instanceof BBoolean) {
                config.addDataSourceProperty(key, (Object)((BBoolean)value).booleanValue());
                continue;
            }
            if (!(value instanceof BFloat)) continue;
            config.addDataSourceProperty(key, (Object)((BFloat)value).floatValue());
        }
    }

    public String stringValue() {
        return null;
    }

    public BType getType() {
        return null;
    }

    public BValue copy() {
        return null;
    }

    private boolean isXADataSource() {
        try {
            return this.hikariDataSource.isWrapperFor(XADataSource.class);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in check distributed data source: " + e.getCause().getMessage());
        }
    }
}

