/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.actions.data.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAResource;
import org.ballerinalang.bre.BallerinaTransactionContext;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SQLTransactionContext
implements BallerinaTransactionContext {
    private Connection conn;
    private XAResource xaResource;

    public SQLTransactionContext(Connection conn, XAResource resource) {
        this.conn = conn;
        this.xaResource = resource;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new BallerinaException("transaction commit failed:" + e.getMessage());
        }
    }

    public void rollback() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.rollback();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("transaction rollback failed:" + e.getMessage());
        }
    }

    public void close() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("connection close failed:" + e.getMessage());
        }
    }

    public void done() {
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }
}

