/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.actions.data.sql.client;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.sql.XAConnection;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.ballerinalang.bre.BallerinaTransactionContext;
import org.ballerinalang.bre.BallerinaTransactionManager;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.AbstractNativeAction;
import org.ballerinalang.model.ColumnDefinition;
import org.ballerinalang.model.DataIterator;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BBlobArray;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BDataTable;
import org.ballerinalang.model.values.BEnumerator;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.actions.data.sql.SQLDataIterator;
import org.ballerinalang.nativeimpl.actions.data.sql.SQLDatasource;
import org.ballerinalang.nativeimpl.actions.data.sql.SQLTransactionContext;
import org.ballerinalang.nativeimpl.actions.data.sql.client.SQLDatasourceUtils;
import org.ballerinalang.natives.exceptions.ArgumentOutOfRangeException;
import org.ballerinalang.util.DistributedTxManagerProvider;
import org.ballerinalang.util.exceptions.BallerinaException;

public abstract class AbstractSQLAction
extends AbstractNativeAction {
    public Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public BValue getRefArgument(Context context, int index) {
        if (index > -1) {
            return context.getControlStackNew().getCurrentFrame().getRefLocalVars()[index];
        }
        throw new ArgumentOutOfRangeException(index);
    }

    protected void executeQuery(Context context, SQLDatasource datasource, String query, BRefValueArray parameters) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            conn = this.getDatabaseConnection(context, datasource, isInTransaction);
            String processedQuery = this.createProcessedQueryString(query, parameters);
            stmt = this.getPreparedStatement(conn, datasource, processedQuery);
            this.createProcessedStatement(conn, stmt, parameters);
            rs = stmt.executeQuery();
            context.getControlStackNew().getCurrentFrame().returnValues[0] = this.constructDataTable(rs, stmt, conn);
        }
        catch (Throwable e) {
            SQLDatasourceUtils.cleanupConnection(rs, stmt, conn, isInTransaction);
            throw new BallerinaException("execute query failed: " + e.getMessage(), e);
        }
    }

    protected void executeUpdate(Context context, SQLDatasource datasource, String query, BRefValueArray parameters) {
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            conn = this.getDatabaseConnection(context, datasource, isInTransaction);
            String processedQuery = this.createProcessedQueryString(query, parameters);
            stmt = conn.prepareStatement(processedQuery);
            this.createProcessedStatement(conn, stmt, parameters);
            int count = stmt.executeUpdate();
            BInteger updatedCount = new BInteger((long)count);
            context.getControlStackNew().getCurrentFrame().returnValues[0] = updatedCount;
        }
        catch (SQLException e) {
            try {
                throw new BallerinaException("execute update failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLDatasourceUtils.cleanupConnection(null, stmt, conn, isInTransaction);
                throw throwable;
            }
        }
        SQLDatasourceUtils.cleanupConnection(null, stmt, conn, isInTransaction);
    }

    protected void executeUpdateWithKeys(Context context, SQLDatasource datasource, String query, BStringArray keyColumns, BRefValueArray parameters) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            conn = this.getDatabaseConnection(context, datasource, isInTransaction);
            String processedQuery = this.createProcessedQueryString(query, parameters);
            int keyColumnCount = 0;
            if (keyColumns != null) {
                keyColumnCount = (int)keyColumns.size();
            }
            if (keyColumnCount > 0) {
                String[] columnArray = new String[keyColumnCount];
                for (int i = 0; i < keyColumnCount; ++i) {
                    columnArray[i] = keyColumns.get((long)i);
                }
                stmt = conn.prepareStatement(processedQuery, columnArray);
            } else {
                stmt = conn.prepareStatement(processedQuery, 1);
            }
            this.createProcessedStatement(conn, stmt, parameters);
            int count = stmt.executeUpdate();
            BInteger updatedCount = new BInteger((long)count);
            context.getControlStackNew().getCurrentFrame().returnValues[0] = updatedCount;
            rs = stmt.getGeneratedKeys();
            if (rs.next()) {
                BStringArray generatedKeys = this.getGeneratedKeys(rs);
                context.getControlStackNew().getCurrentFrame().returnValues[1] = generatedKeys;
            }
        }
        catch (SQLException e) {
            try {
                throw new BallerinaException("execute update with generated keys failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLDatasourceUtils.cleanupConnection(rs, stmt, conn, isInTransaction);
                throw throwable;
            }
        }
        SQLDatasourceUtils.cleanupConnection(rs, stmt, conn, isInTransaction);
    }

    protected void executeProcedure(Context context, SQLDatasource datasource, String query, BRefValueArray parameters) {
        Connection conn = null;
        CallableStatement stmt = null;
        ResultSet rs = null;
        boolean isInTransaction = context.isInTransaction();
        try {
            conn = this.getDatabaseConnection(context, datasource, isInTransaction);
            stmt = this.getPreparedCall(conn, datasource, query, parameters);
            this.createProcessedStatement(conn, stmt, parameters);
            rs = this.executeStoredProc(stmt);
            this.setOutParameters(stmt, parameters);
            if (rs != null) {
                context.getControlStackNew().getCurrentFrame().returnValues[0] = this.constructDataTable(rs, stmt, conn);
            } else {
                SQLDatasourceUtils.cleanupConnection(null, stmt, conn, isInTransaction);
            }
        }
        catch (Throwable e) {
            SQLDatasourceUtils.cleanupConnection(rs, stmt, conn, isInTransaction);
            throw new BallerinaException("execute stored procedure failed: " + e.getMessage(), e);
        }
    }

    protected void executeBatchUpdate(Context context, SQLDatasource datasource, String query, BRefValueArray parameters) {
        int[] updatedCount;
        Connection conn = null;
        PreparedStatement stmt = null;
        int paramArrayCount = 0;
        try {
            conn = datasource.getSQLConnection();
            stmt = conn.prepareStatement(query);
            this.setConnectionAutoCommit(conn, false);
            if (parameters != null) {
                paramArrayCount = (int)parameters.size();
                for (int index = 0; index < paramArrayCount; ++index) {
                    BRefValueArray params = (BRefValueArray)parameters.get((long)index);
                    this.createProcessedStatement(conn, stmt, params);
                    stmt.addBatch();
                }
            } else {
                this.createProcessedStatement(conn, stmt, null);
                stmt.addBatch();
            }
            updatedCount = stmt.executeBatch();
            conn.commit();
        }
        catch (BatchUpdateException e) {
            updatedCount = e.getUpdateCounts();
        }
        catch (SQLException e) {
            throw new BallerinaException("execute batch update failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.setConnectionAutoCommit(conn, true);
            SQLDatasourceUtils.cleanupConnection(null, stmt, conn, false);
        }
        long[] returnedCount = new long[paramArrayCount];
        Arrays.fill(returnedCount, -3L);
        BIntArray countArray = new BIntArray(returnedCount);
        if (updatedCount != null) {
            int iSize = updatedCount.length;
            for (int i = 0; i < iSize; ++i) {
                countArray.add((long)i, (long)updatedCount[i]);
            }
        }
        context.getControlStackNew().getCurrentFrame().returnValues[0] = countArray;
    }

    private String createProcessedQueryString(String query, BRefValueArray parameters) {
        String currentQuery = query;
        if (parameters != null) {
            int start = 0;
            int paramCount = (int)parameters.size();
            for (int i = 0; i < paramCount; ++i) {
                BStruct paramValue = (BStruct)parameters.get((long)i);
                if (paramValue == null) continue;
                String sqlType = this.getSQLType(paramValue);
                BRefType value = paramValue.getRefField(1);
                int count = value != null && value.getType().getTag() == 16 && !"ARRAY".equalsIgnoreCase(sqlType) ? (int)((BNewArray)value).size() : 1;
                Object[] vals = this.expandQuery(start, count, currentQuery);
                start = (Integer)vals[0];
                currentQuery = (String)vals[1];
            }
        }
        return currentQuery;
    }

    private Object[] expandQuery(int start, int count, String query) {
        StringBuilder result = new StringBuilder();
        int n = query.length();
        boolean doubleQuoteExists = false;
        boolean singleQuoteExists = false;
        int end = n;
        for (int i = start; i < n; ++i) {
            if (query.charAt(i) == '\'') {
                singleQuoteExists = !singleQuoteExists;
                continue;
            }
            if (query.charAt(i) == '\"') {
                doubleQuoteExists = !doubleQuoteExists;
                continue;
            }
            if (query.charAt(i) != '?' || doubleQuoteExists || singleQuoteExists) continue;
            result.append(query.substring(0, i));
            result.append(this.generateQuestionMarks(count));
            end = result.length() + 1;
            if (i + 1 >= n) break;
            result.append(query.substring(i + 1));
            break;
        }
        return new Object[]{end, result.toString()};
    }

    private String generateQuestionMarks(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("?");
            if (i + 1 >= n) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private void setConnectionAutoCommit(Connection conn, boolean status) {
        try {
            if (conn != null) {
                conn.setAutoCommit(status);
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("set connection commit status failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void closeConnections(SQLDatasource datasource) {
        datasource.closeConnectionPool();
    }

    private PreparedStatement getPreparedStatement(Connection conn, SQLDatasource datasource, String query) throws SQLException {
        PreparedStatement stmt;
        boolean mysql = datasource.getDatabaseName().contains("mysql");
        if (mysql) {
            stmt = conn.prepareStatement(query, 1003, 1007);
            try {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            catch (SQLException e) {
                stmt.close();
            }
        } else {
            stmt = conn.prepareStatement(query);
        }
        return stmt;
    }

    private CallableStatement getPreparedCall(Connection conn, SQLDatasource datasource, String query, BRefValueArray parameters) throws SQLException {
        CallableStatement stmt;
        boolean mysql = datasource.getDatabaseName().contains("mysql");
        if (mysql) {
            stmt = conn.prepareCall(query, 1003, 1007);
            if (parameters != null && !this.hasOutParams(parameters)) {
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
        } else {
            stmt = conn.prepareCall(query);
        }
        return stmt;
    }

    private List<ColumnDefinition> getColumnDefinitions(ResultSet rs) throws SQLException {
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        HashSet<String> columnNames = new HashSet<String>();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int cols = rsMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String colName = rsMetaData.getColumnLabel(i);
            if (columnNames.contains(colName)) {
                String tableName = rsMetaData.getTableName(i).toUpperCase();
                colName = tableName + "." + colName;
            }
            int colType = rsMetaData.getColumnType(i);
            TypeKind mappedType = SQLDatasourceUtils.getColumnType(colType);
            columnDefs.add(new SQLDataIterator.SQLColumnDefinition(colName, mappedType, colType));
            columnNames.add(colName);
        }
        return columnDefs;
    }

    private BStringArray getGeneratedKeys(ResultSet rs) throws SQLException {
        BStringArray generatedKeys = new BStringArray();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String value;
            int columnType = metaData.getColumnType(i);
            switch (columnType) {
                case -6: 
                case 4: 
                case 5: {
                    value = Integer.toString(rs.getInt(i));
                    break;
                }
                case 8: {
                    value = Double.toString(rs.getDouble(i));
                    break;
                }
                case 6: {
                    value = Float.toString(rs.getFloat(i));
                    break;
                }
                case -7: 
                case 16: {
                    value = Boolean.toString(rs.getBoolean(i));
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = rs.getBigDecimal(i);
                    if (bigDecimal != null) {
                        value = bigDecimal.toPlainString();
                        break;
                    }
                    value = null;
                    break;
                }
                case -5: {
                    value = Long.toString(rs.getLong(i));
                    break;
                }
                default: {
                    value = rs.getString(i);
                }
            }
            generatedKeys.add((long)(i - 1), value);
        }
        return generatedKeys;
    }

    private void createProcessedStatement(Connection conn, PreparedStatement stmt, BRefValueArray params) {
        if (params == null) {
            return;
        }
        int paramCount = (int)params.size();
        int currentOrdinal = 0;
        for (int index = 0; index < paramCount; ++index) {
            BStruct paramStruct = (BStruct)params.get((long)index);
            if (paramStruct != null) {
                String sqlType = this.getSQLType(paramStruct);
                BRefType value = paramStruct.getRefField(1);
                int direction = this.getParameterDirection(paramStruct);
                if (value != null && value.getType().getTag() == 16 && !"ARRAY".equalsIgnoreCase(sqlType)) {
                    int arrayLength = (int)((BNewArray)value).size();
                    int typeTag = ((BArrayType)value.getType()).getElementType().getTag();
                    for (int i = 0; i < arrayLength; ++i) {
                        BInteger paramValue;
                        switch (typeTag) {
                            case 1: {
                                paramValue = new BInteger(((BIntArray)value).get((long)i));
                                break;
                            }
                            case 2: {
                                paramValue = new BFloat(((BFloatArray)value).get((long)i));
                                break;
                            }
                            case 3: {
                                paramValue = new BString(((BStringArray)value).get((long)i));
                                break;
                            }
                            case 4: {
                                paramValue = new BBoolean(((BBooleanArray)value).get((long)i) > 0);
                                break;
                            }
                            case 5: {
                                paramValue = new BBlob(((BBlobArray)value).get((long)i));
                                break;
                            }
                            default: {
                                throw new BallerinaException("unsupported array type for parameter index " + index);
                            }
                        }
                        this.setParameter(conn, stmt, sqlType, (BValue)paramValue, direction, currentOrdinal);
                        ++currentOrdinal;
                    }
                    continue;
                }
                this.setParameter(conn, stmt, sqlType, (BValue)value, direction, currentOrdinal);
                ++currentOrdinal;
                continue;
            }
            SQLDatasourceUtils.setNullObject(stmt, index);
            ++currentOrdinal;
        }
    }

    private void setParameter(Connection conn, PreparedStatement stmt, String sqlType, BValue value, int direction, int index) {
        if (sqlType == null || sqlType.isEmpty()) {
            SQLDatasourceUtils.setStringValue(stmt, value, index, direction, 12);
        } else {
            String sqlDataType;
            switch (sqlDataType = sqlType.toUpperCase(Locale.getDefault())) {
                case "SMALLINT": {
                    SQLDatasourceUtils.setIntValue(stmt, value, index, direction, 4);
                    break;
                }
                case "VARCHAR": {
                    SQLDatasourceUtils.setStringValue(stmt, value, index, direction, 12);
                    break;
                }
                case "CHAR": {
                    SQLDatasourceUtils.setStringValue(stmt, value, index, direction, 1);
                    break;
                }
                case "LONGVARCHAR": {
                    SQLDatasourceUtils.setStringValue(stmt, value, index, direction, -1);
                    break;
                }
                case "NCHAR": {
                    SQLDatasourceUtils.setNStringValue(stmt, value, index, direction, -15);
                    break;
                }
                case "NVARCHAR": {
                    SQLDatasourceUtils.setNStringValue(stmt, value, index, direction, -9);
                    break;
                }
                case "LONGNVARCHAR": {
                    SQLDatasourceUtils.setNStringValue(stmt, value, index, direction, -16);
                    break;
                }
                case "DOUBLE": {
                    SQLDatasourceUtils.setDoubleValue(stmt, value, index, direction, 8);
                    break;
                }
                case "NUMERIC": 
                case "DECIMAL": {
                    SQLDatasourceUtils.setNumericValue(stmt, value, index, direction, 2);
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    SQLDatasourceUtils.setBooleanValue(stmt, value, index, direction, -7);
                    break;
                }
                case "TINYINT": {
                    SQLDatasourceUtils.setTinyIntValue(stmt, value, index, direction, -6);
                    break;
                }
                case "BIGINT": 
                case "INTEGER": {
                    SQLDatasourceUtils.setBigIntValue(stmt, value, index, direction, -5);
                    break;
                }
                case "REAL": 
                case "FLOAT": {
                    SQLDatasourceUtils.setRealValue(stmt, value, index, direction, 6);
                    break;
                }
                case "DATE": {
                    SQLDatasourceUtils.setDateValue(stmt, value, index, direction, 91);
                    break;
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    SQLDatasourceUtils.setTimeStampValue(stmt, value, index, direction, 93, this.utcCalendar);
                    break;
                }
                case "TIME": {
                    SQLDatasourceUtils.setTimeValue(stmt, value, index, direction, 92, this.utcCalendar);
                    break;
                }
                case "BINARY": {
                    SQLDatasourceUtils.setBinaryValue(stmt, value, index, direction, -2);
                    break;
                }
                case "BLOB": {
                    SQLDatasourceUtils.setBlobValue(stmt, value, index, direction, 2004);
                    break;
                }
                case "LONGVARBINARY": {
                    SQLDatasourceUtils.setBlobValue(stmt, value, index, direction, -4);
                    break;
                }
                case "VARBINARY": {
                    SQLDatasourceUtils.setBinaryValue(stmt, value, index, direction, -3);
                    break;
                }
                case "CLOB": {
                    SQLDatasourceUtils.setClobValue(stmt, value, index, direction, 2005);
                    break;
                }
                case "NCLOB": {
                    SQLDatasourceUtils.setNClobValue(stmt, value, index, direction, 2011);
                    break;
                }
                case "ARRAY": {
                    SQLDatasourceUtils.setArrayValue(conn, stmt, value, index, direction, 2003);
                    break;
                }
                case "STRUCT": {
                    SQLDatasourceUtils.setUserDefinedValue(conn, stmt, value, index, direction, 2002);
                    break;
                }
                default: {
                    throw new BallerinaException("unsupported datatype as parameter: " + sqlType + " index:" + index);
                }
            }
        }
    }

    private void setOutParameters(CallableStatement stmt, BRefValueArray params) {
        if (params == null) {
            return;
        }
        int paramCount = (int)params.size();
        for (int index = 0; index < paramCount; ++index) {
            BStruct paramValue = (BStruct)params.get((long)index);
            if (paramValue != null) {
                String sqlType = this.getSQLType(paramValue);
                int direction = this.getParameterDirection(paramValue);
                if (direction != 2 && direction != 1) continue;
                this.setOutParameterValue(stmt, sqlType, index, paramValue);
                continue;
            }
            throw new BallerinaException("out value cannot set for null parameter with index: " + index);
        }
    }

    private void setOutParameterValue(CallableStatement stmt, String sqlType, int index, BStruct paramValue) {
        try {
            String sqlDataType;
            switch (sqlDataType = sqlType.toUpperCase(Locale.getDefault())) {
                case "INTEGER": {
                    int value = stmt.getInt(index + 1);
                    paramValue.setRefField(1, (BRefType)new BInteger((long)value));
                    break;
                }
                case "VARCHAR": {
                    String value = stmt.getString(index + 1);
                    paramValue.setRefField(1, (BRefType)new BString(value));
                    break;
                }
                case "NUMERIC": 
                case "DECIMAL": {
                    BigDecimal value = stmt.getBigDecimal(index + 1);
                    if (value == null) {
                        paramValue.setRefField(1, (BRefType)new BFloat(0.0));
                        break;
                    }
                    paramValue.setRefField(1, (BRefType)new BFloat(value.doubleValue()));
                    break;
                }
                case "BIT": 
                case "BOOLEAN": {
                    boolean value = stmt.getBoolean(index + 1);
                    paramValue.setRefField(1, (BRefType)new BBoolean(value));
                    break;
                }
                case "TINYINT": {
                    byte value = stmt.getByte(index + 1);
                    paramValue.setRefField(1, (BRefType)new BInteger((long)value));
                    break;
                }
                case "SMALLINT": {
                    short value = stmt.getShort(index + 1);
                    paramValue.setRefField(1, (BRefType)new BInteger((long)value));
                    break;
                }
                case "BIGINT": {
                    long value = stmt.getLong(index + 1);
                    paramValue.setRefField(1, (BRefType)new BInteger(value));
                    break;
                }
                case "REAL": 
                case "FLOAT": {
                    float value = stmt.getFloat(index + 1);
                    paramValue.setRefField(1, (BRefType)new BFloat((double)value));
                    break;
                }
                case "DOUBLE": {
                    double value = stmt.getDouble(index + 1);
                    paramValue.setRefField(1, (BRefType)new BFloat(value));
                    break;
                }
                case "CLOB": {
                    Clob value = stmt.getClob(index + 1);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "BLOB": {
                    Blob value = stmt.getBlob(index + 1);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "BINARY": {
                    byte[] value = stmt.getBytes(index + 1);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "DATE": {
                    Date value = stmt.getDate(index + 1);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    Timestamp value = stmt.getTimestamp(index + 1, this.utcCalendar);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "TIME": {
                    Time value = stmt.getTime(index + 1, this.utcCalendar);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "ARRAY": {
                    Array value = stmt.getArray(index + 1);
                    paramValue.setRefField(1, (BRefType)new BString(SQLDatasourceUtils.getString(value)));
                    break;
                }
                case "STRUCT": {
                    Object value = stmt.getObject(index + 1);
                    String stringValue = "";
                    if (value != null) {
                        stringValue = value instanceof Struct ? SQLDatasourceUtils.getString((Struct)value) : value.toString();
                    }
                    paramValue.setRefField(1, (BRefType)new BString(stringValue));
                    break;
                }
                default: {
                    throw new BallerinaException("unsupported datatype as out/inout parameter: " + sqlType + " index:" + index);
                }
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error in getting out parameter value: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasOutParams(BRefValueArray params) {
        int paramCount = (int)params.size();
        for (int index = 0; index < paramCount; ++index) {
            BStruct paramValue = (BStruct)params.get((long)index);
            int direction = this.getParameterDirection(paramValue);
            if (direction != 1 && direction != 2) continue;
            return true;
        }
        return false;
    }

    private ResultSet executeStoredProc(CallableStatement stmt) throws SQLException {
        boolean resultAndNoUpdateCount = stmt.execute();
        ResultSet result = null;
        while (true) {
            if (!resultAndNoUpdateCount) {
                int updateCount = stmt.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
            } else {
                result = stmt.getResultSet();
                break;
            }
            try {
                resultAndNoUpdateCount = stmt.getMoreResults(2);
            }
            catch (SQLException e) {
                break;
            }
        }
        return result;
    }

    private Connection getDatabaseConnection(Context context, SQLDatasource datasource, boolean isInTransaction) throws SQLException {
        Connection conn = null;
        if (!isInTransaction) {
            conn = datasource.getSQLConnection();
            return conn;
        }
        String connectorId = datasource.getConnectorId();
        boolean isXAConnection = datasource.isXAConnection();
        BallerinaTransactionManager ballerinaTxManager = context.getBallerinaTransactionManager();
        BallerinaTransactionContext txContext = ballerinaTxManager.getTransactionContext(connectorId);
        if (txContext == null) {
            if (isXAConnection) {
                if (!ballerinaTxManager.hasXATransactionManager()) {
                    TransactionManager transactionManager = DistributedTxManagerProvider.getInstance().getTransactionManager();
                    ballerinaTxManager.setXATransactionManager(transactionManager);
                }
                if (!ballerinaTxManager.isInXATransaction()) {
                    ballerinaTxManager.beginXATransaction();
                }
                XAConnection xaConn = datasource.getXADataSource().getXAConnection();
                XAResource xaResource = xaConn.getXAResource();
                conn = xaConn.getConnection();
                txContext = new SQLTransactionContext(conn, xaResource);
                ballerinaTxManager.registerTransactionContext(connectorId, txContext);
            } else {
                conn = datasource.getSQLConnection();
                conn.setAutoCommit(false);
                txContext = new SQLTransactionContext(conn, null);
                ballerinaTxManager.registerTransactionContext(connectorId, txContext);
            }
        } else {
            conn = ((SQLTransactionContext)txContext).getConnection();
        }
        return conn;
    }

    private BDataTable constructDataTable(ResultSet rs, Statement stmt, Connection conn) throws SQLException {
        List<ColumnDefinition> columnDefinitions = this.getColumnDefinitions(rs);
        return new BDataTable((DataIterator)new SQLDataIterator(conn, stmt, rs, this.utcCalendar, columnDefinitions));
    }

    private String getSQLType(BStruct parameter) {
        String sqlType = "";
        BEnumerator typeEnum = (BEnumerator)parameter.getRefField(0);
        if (typeEnum != null) {
            sqlType = typeEnum.getName();
        }
        return sqlType;
    }

    private int getParameterDirection(BStruct parameter) {
        int direction = 0;
        BEnumerator dirEnum = (BEnumerator)parameter.getRefField(2);
        if (dirEnum != null) {
            String sqlType;
            switch (sqlType = dirEnum.getName()) {
                case "OUT": {
                    direction = 1;
                    break;
                }
                case "INOUT": {
                    direction = 2;
                }
            }
        }
        return direction;
    }
}

