/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.actions.data.sql.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.TimeZone;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BBlobArray;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SQLDatasourceUtils {
    public static void setIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Integer val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Integer.parseInt(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for integer: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setInt(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setInt(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set integer to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setStringValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            try {
                if (0 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setString(index + 1, value.stringValue());
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setString(index + 1, value.stringValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set string to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNStringValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            try {
                if (0 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNString(index + 1, value.stringValue());
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (value == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNString(index + 1, value.stringValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set string to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setDoubleValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Double val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Double.parseDouble(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for double: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDouble(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDouble(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set double to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNumericValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            BigDecimal val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = new BigDecimal(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for numeric: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBigDecimal(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBigDecimal(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set numeric value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBooleanValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block10: {
            String strValue;
            Boolean val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                val = Boolean.valueOf(strValue);
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBoolean(index + 1, val);
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBoolean(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set boolean value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setTinyIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Byte val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Byte.valueOf(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for byte: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setByte(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setByte(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set tinyint value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBigIntValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Long val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Long.parseLong(strValue);
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for bigint: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setLong(index + 1, val);
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setLong(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set bigint value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setRealValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block12: {
            String strValue;
            Float val = null;
            if (value != null && !(strValue = value.stringValue()).isEmpty()) {
                try {
                    val = Float.valueOf(Float.parseFloat(strValue));
                }
                catch (NumberFormatException e) {
                    throw new BallerinaException("invalid value for float: " + strValue);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setFloat(index + 1, val.floatValue());
                    }
                    break block12;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setFloat(index + 1, val.floatValue());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block12;
                }
                throw new BallerinaException("invalid direction for the parameter, index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set float value to statement." + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setDateValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block16: {
            Date val = null;
            if (value != null) {
                if (value instanceof BStruct && value.getType().getName().equals("Time") && value.getType().getPackagePath().equals("ballerina.builtin")) {
                    val = new Date(((BStruct)value).getIntField(0));
                } else if (value instanceof BInteger) {
                    val = new Date(((BInteger)value).intValue());
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.convertToDate(value.stringValue());
                } else {
                    throw new BallerinaException("invalid input type for date parameter with index: " + index);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDate(index + 1, val);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setDate(index + 1, val);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set date value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setTimeStampValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType, Calendar utcCalendar) {
        block16: {
            Timestamp val = null;
            if (value != null) {
                if (value instanceof BStruct && value.getType().getName().equals("Time") && value.getType().getPackagePath().equals("ballerina.builtin")) {
                    val = new Timestamp(((BStruct)value).getIntField(0));
                } else if (value instanceof BInteger) {
                    val = new Timestamp(((BInteger)value).intValue());
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.convertToTimeStamp(value.stringValue());
                } else {
                    throw new BallerinaException("invalid input type for timestamp parameter with index: " + index);
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTimestamp(index + 1, val, utcCalendar);
                    }
                    break block16;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTimestamp(index + 1, val, utcCalendar);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block16;
                }
                throw new BallerinaException("invalid direction for the parameter, index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set timestamp value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setTimeValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType, Calendar utcCalendar) {
        block15: {
            Time val = null;
            if (value != null) {
                if (value instanceof BStruct && value.getType().getName().equals("Time") && value.getType().getPackagePath().equals("ballerina.builtin")) {
                    val = new Time(((BStruct)value).getIntField(0));
                } else if (value instanceof BInteger) {
                    val = new Time(((BInteger)value).intValue());
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.convertToTime(value.stringValue());
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTime(index + 1, val, utcCalendar);
                    }
                    break block15;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setTime(index + 1, val, utcCalendar);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block15;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block15;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set timestamp value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBinaryValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block13: {
            byte[] val = null;
            if (value != null) {
                if (value instanceof BBlob) {
                    val = ((BBlob)value).blobValue();
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.getBytesFromBase64String(value.stringValue());
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBinaryStream(index + 1, (InputStream)new ByteArrayInputStream(val), val.length);
                    }
                    break block13;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBinaryStream(index + 1, (InputStream)new ByteArrayInputStream(val), val.length);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block13;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block13;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setBlobValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block13: {
            byte[] val = null;
            if (value != null) {
                if (value instanceof BBlob) {
                    val = ((BBlob)value).blobValue();
                } else if (value instanceof BString) {
                    val = SQLDatasourceUtils.getBytesFromBase64String(value.stringValue());
                }
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBlob(index + 1, new ByteArrayInputStream(val), val.length);
                    }
                    break block13;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setBlob(index + 1, new ByteArrayInputStream(val), val.length);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block13;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block13;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setClobValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block10: {
            BufferedReader val = null;
            if (value != null) {
                val = new BufferedReader(new StringReader(value.stringValue()));
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setClob(index + 1, val, value.stringValue().length());
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setClob(index + 1, val, value.stringValue().length());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNClobValue(PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block10: {
            BufferedReader val = null;
            if (value != null) {
                val = new BufferedReader(new StringReader(value.stringValue()));
            }
            try {
                if (0 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNClob(index + 1, val, value.stringValue().length());
                    }
                    break block10;
                }
                if (2 == direction) {
                    if (val == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        stmt.setNClob(index + 1, val, value.stringValue().length());
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType);
                    break block10;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set binary value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setArrayValue(Connection conn, PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            Object[] arrayData = SQLDatasourceUtils.getArrayData(value);
            Object[] arrayValue = (Object[])arrayData[0];
            String structuredSQLType = (String)arrayData[1];
            try {
                if (0 == direction) {
                    if (arrayValue == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        Array array = conn.createArrayOf(structuredSQLType, arrayValue);
                        stmt.setArray(index + 1, array);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (arrayValue == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        Array array = conn.createArrayOf(structuredSQLType, arrayValue);
                        stmt.setArray(index + 1, array);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set array value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setNullObject(PreparedStatement stmt, int index) {
        try {
            stmt.setObject(index + 1, null);
        }
        catch (SQLException e) {
            throw new BallerinaException("error in set null to parameter with index: " + index);
        }
    }

    private static Object[] getArrayData(BValue value) {
        if (value == null || value.getType().getTag() != 16) {
            return new Object[]{null, null};
        }
        int typeTag = ((BArrayType)value.getType()).getElementType().getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = (int)((BIntArray)value).size();
                Long[] arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BIntArray)value).get((long)i);
                }
                return new Object[]{arrayData, "BIGINT"};
            }
            case 2: {
                int arrayLength = (int)((BFloatArray)value).size();
                Double[] arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BFloatArray)value).get((long)i);
                }
                return new Object[]{arrayData, "DOUBLE"};
            }
            case 3: {
                int arrayLength = (int)((BStringArray)value).size();
                String[] arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BStringArray)value).get((long)i);
                }
                return new Object[]{arrayData, "VARCHAR"};
            }
            case 4: {
                int arrayLength = (int)((BBooleanArray)value).size();
                Boolean[] arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BBooleanArray)value).get((long)i) > 0;
                }
                return new Object[]{arrayData, "BOOLEAN"};
            }
            case 5: {
                int arrayLength = (int)((BBlobArray)value).size();
                Blob[] arrayData = new Blob[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BBlobArray)value).get((long)i);
                }
                return new Object[]{arrayData, "BLOB"};
            }
        }
        throw new BallerinaException("unsupported data type for array parameter");
    }

    public static void setUserDefinedValue(Connection conn, PreparedStatement stmt, BValue value, int index, int direction, int sqlType) {
        block9: {
            Object[] structData = SQLDatasourceUtils.getStructData(value);
            Object[] dataArray = (Object[])structData[0];
            String structuredSQLType = (String)structData[1];
            try {
                if (0 == direction) {
                    if (dataArray == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        Struct struct = conn.createStruct(structuredSQLType, dataArray);
                        stmt.setObject(index + 1, struct);
                    }
                    break block9;
                }
                if (2 == direction) {
                    if (dataArray == null) {
                        stmt.setNull(index + 1, sqlType);
                    } else {
                        Struct struct = conn.createStruct(structuredSQLType, dataArray);
                        stmt.setObject(index + 1, struct);
                    }
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
                    break block9;
                }
                if (1 == direction) {
                    ((CallableStatement)stmt).registerOutParameter(index + 1, sqlType, structuredSQLType);
                    break block9;
                }
                throw new BallerinaException("invalid direction for the parameter with index: " + index);
            }
            catch (SQLException e) {
                throw new BallerinaException("error in set struct value to statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Object[] getStructData(BValue value) {
        if (value == null || value.getType().getTag() != 15) {
            return new Object[]{null, null};
        }
        String structuredSQLType = value.getType().getName().toUpperCase(Locale.getDefault());
        BStructType.StructField[] structFields = ((BStructType)value.getType()).getStructFields();
        int fieldCount = structFields.length;
        Object[] structData = new Object[fieldCount];
        int intFieldIndex = 0;
        int floatFieldIndex = 0;
        int stringFieldIndex = 0;
        int booleanFieldIndex = 0;
        int blobFieldIndex = 0;
        block7: for (int i = 0; i < fieldCount; ++i) {
            BStructType.StructField field = structFields[i];
            int typeTag = field.getFieldType().getTag();
            switch (typeTag) {
                case 1: {
                    structData[i] = ((BStruct)value).getIntField(intFieldIndex);
                    ++intFieldIndex;
                    continue block7;
                }
                case 2: {
                    structData[i] = ((BStruct)value).getFloatField(floatFieldIndex);
                    ++floatFieldIndex;
                    continue block7;
                }
                case 3: {
                    structData[i] = ((BStruct)value).getStringField(stringFieldIndex);
                    ++stringFieldIndex;
                    continue block7;
                }
                case 4: {
                    structData[i] = ((BStruct)value).getBooleanField(booleanFieldIndex) > 0;
                    ++booleanFieldIndex;
                    continue block7;
                }
                case 5: {
                    structData[i] = ((BStruct)value).getBlobField(blobFieldIndex);
                    ++blobFieldIndex;
                    continue block7;
                }
                default: {
                    throw new BallerinaException("unsupported data type for struct parameter: " + structuredSQLType);
                }
            }
        }
        return new Object[]{structData, structuredSQLType};
    }

    public static void cleanupConnection(ResultSet rs, Statement stmt, Connection conn, boolean isInTransaction) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
            if (conn != null && !conn.isClosed() && !isInTransaction) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BallerinaException("error cleaning sql resources: " + e.getMessage(), (Throwable)e);
        }
    }

    public static TypeKind getColumnType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return TypeKind.ARRAY;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: 
            case 2011: 
            case 2013: 
            case 2014: {
                return TypeKind.STRING;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return TypeKind.INT;
            }
            case -7: 
            case 16: {
                return TypeKind.BOOLEAN;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return TypeKind.FLOAT;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return TypeKind.BLOB;
            }
        }
        return TypeKind.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(Clob data) {
        if (data == null) {
            return null;
        }
        try (BufferedReader r = new BufferedReader(data.getCharacterStream());){
            int pos;
            StringBuilder sb = new StringBuilder();
            while ((pos = ((Reader)r).read()) != -1) {
                sb.append((char)pos);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException | SQLException e) {
            throw new BallerinaException("error occurred while reading clob value: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String getString(Blob data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] encode = SQLDatasourceUtils.getBase64Encode(new String(data.getBytes(1L, (int)data.length()), Charset.defaultCharset()));
            return new String(encode, Charset.defaultCharset());
        }
        catch (SQLException e) {
            throw new BallerinaException("error occurred while reading blob value", (Throwable)e);
        }
    }

    public static String getString(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(data, Charset.defaultCharset());
    }

    public static String getString(Date value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(value);
        return SQLDatasourceUtils.getString(calendar, "date");
    }

    public static String getString(Timestamp value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(value.getTime());
        return SQLDatasourceUtils.getString(calendar, "datetime");
    }

    public static String getString(Time value) {
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(value.getTime());
        return SQLDatasourceUtils.getString(calendar, "time");
    }

    public static String getString(Array dataArray) throws SQLException {
        if (dataArray == null) {
            return null;
        }
        StringJoiner sj = new StringJoiner(",", "[", "]");
        ResultSet rs = dataArray.getResultSet();
        while (rs.next()) {
            Object arrayEl = rs.getObject(2);
            String val = String.valueOf(arrayEl);
            sj.add(val);
        }
        return sj.toString();
    }

    public static String getString(Struct udt) throws SQLException {
        if (udt.getAttributes() != null) {
            StringJoiner sj = new StringJoiner(",", "{", "}");
            Object[] udtValues = udt.getAttributes();
            for (int i = 0; i < udtValues.length; ++i) {
                sj.add(String.valueOf(udtValues[i]));
            }
            return sj.toString();
        }
        return null;
    }

    private static String getString(Calendar calendar, String type) {
        if (!calendar.isSet(15)) {
            calendar.setTimeZone(TimeZone.getDefault());
        }
        StringBuffer datetimeString = new StringBuffer(28);
        switch (type) {
            case "date": {
                SQLDatasourceUtils.appendDate(datetimeString, calendar);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            case "time": {
                SQLDatasourceUtils.appendTime(calendar, datetimeString);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            case "datetime": {
                SQLDatasourceUtils.appendDate(datetimeString, calendar);
                datetimeString.append("T");
                SQLDatasourceUtils.appendTime(calendar, datetimeString);
                SQLDatasourceUtils.appendTimeZone(calendar, datetimeString);
                break;
            }
            default: {
                throw new BallerinaException("invalid type for datetime data: " + type);
            }
        }
        return datetimeString.toString();
    }

    private static byte[] getBytesFromBase64String(String base64Str) {
        try {
            return Base64.getDecoder().decode(base64Str.getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new BallerinaException("error in processing base64 string: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] getBase64Encode(String st) {
        return Base64.getEncoder().encode(st.getBytes(Charset.defaultCharset()));
    }

    private static String getStringFromInputStream(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw new BallerinaException("failed to read binary as a string: " + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer dateString) {
        int timezoneOffSet = calendar.get(15) + calendar.get(16);
        int timezoneOffSetInMinits = timezoneOffSet / 60000;
        if (timezoneOffSetInMinits < 0) {
            dateString.append("-");
            timezoneOffSetInMinits *= -1;
        } else {
            dateString.append("+");
        }
        int hours = timezoneOffSetInMinits / 60;
        int minits = timezoneOffSetInMinits % 60;
        if (hours < 10) {
            dateString.append("0");
        }
        dateString.append(hours).append(":");
        if (minits < 10) {
            dateString.append("0");
        }
        dateString.append(minits);
    }

    private static void appendTime(Calendar value, StringBuffer dateString) {
        if (value.get(11) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(11)).append(":");
        if (value.get(12) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(12)).append(":");
        if (value.get(13) < 10) {
            dateString.append("0");
        }
        dateString.append(value.get(13)).append(".");
        if (value.get(14) < 10) {
            dateString.append("0");
        }
        if (value.get(14) < 100) {
            dateString.append("0");
        }
        dateString.append(value.get(14));
    }

    private static void appendDate(StringBuffer dateString, Calendar calendar) {
        int year = calendar.get(1);
        if (year < 1000) {
            dateString.append("0");
        }
        if (year < 100) {
            dateString.append("0");
        }
        if (year < 10) {
            dateString.append("0");
        }
        dateString.append(year).append("-");
        int month = calendar.get(2) + 1;
        if (month < 10) {
            dateString.append("0");
        }
        dateString.append(month).append("-");
        if (calendar.get(5) < 10) {
            dateString.append("0");
        }
        dateString.append(calendar.get(5));
    }

    private static Date convertToDate(String source) {
        int timeZoneOffSet;
        int day;
        int month;
        int year;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        if (source.length() >= 10) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-') {
                throw new BallerinaException("invalid date format: " + source);
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 10) {
                String restpart = source.substring(10);
                timeZoneOffSet = SQLDatasourceUtils.getTimeZoneOffset(restpart);
                calendar.set(16, 0);
            }
        } else {
            throw new BallerinaException("invalid date string to parse: " + source);
        }
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(15, timeZoneOffSet);
        return new Date(calendar.getTime().getTime());
    }

    private static Time convertToTime(String source) {
        int timeZoneOffSet;
        int miliSecond;
        int second;
        int minite;
        int hour;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.length() >= 8) {
            if (source.charAt(2) != ':' || source.charAt(5) != ':') {
                throw new BallerinaException("invalid time format: " + source);
            }
            hour = Integer.parseInt(source.substring(0, 2));
            minite = Integer.parseInt(source.substring(3, 5));
            second = Integer.parseInt(source.substring(6, 8));
            miliSecond = 0;
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 8) {
                String rest = source.substring(8);
                int[] offsetData = SQLDatasourceUtils.getTimeZoneWithMilliSeconds(rest);
                miliSecond = offsetData[0];
                timeZoneOffSet = offsetData[1];
                calendar.set(16, 0);
            }
        } else {
            throw new BallerinaException("time string can not be less than 8 characters: " + source);
        }
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        calendar.set(14, miliSecond);
        calendar.set(15, timeZoneOffSet);
        return new Time(calendar.getTimeInMillis());
    }

    private static Timestamp convertToTimeStamp(String source) {
        int timeZoneOffSet;
        long miliSecond;
        int second;
        int minite;
        int hour;
        int day;
        int month;
        int year;
        if (source == null || source.trim().equals("")) {
            return null;
        }
        source = source.trim();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        if (source.startsWith("-")) {
            source = source.substring(1);
            calendar.set(0, 0);
        }
        if (source.length() >= 19) {
            if (source.charAt(4) != '-' || source.charAt(7) != '-' || source.charAt(10) != 'T' || source.charAt(13) != ':' || source.charAt(16) != ':') {
                throw new BallerinaException("invalid datetime format: " + source);
            }
            year = Integer.parseInt(source.substring(0, 4));
            month = Integer.parseInt(source.substring(5, 7));
            day = Integer.parseInt(source.substring(8, 10));
            hour = Integer.parseInt(source.substring(11, 13));
            minite = Integer.parseInt(source.substring(14, 16));
            second = Integer.parseInt(source.substring(17, 19));
            miliSecond = 0L;
            timeZoneOffSet = TimeZone.getDefault().getRawOffset();
            if (source.length() > 19) {
                String rest = source.substring(19);
                int[] offsetData = SQLDatasourceUtils.getTimeZoneWithMilliSeconds(rest);
                miliSecond = offsetData[0];
                int calculatedtimeZoneOffSet = offsetData[1];
                if (calculatedtimeZoneOffSet != -1) {
                    timeZoneOffSet = calculatedtimeZoneOffSet;
                }
                calendar.set(16, 0);
            }
        } else {
            throw new BallerinaException("datetime string can not be less than 19 characters: " + source);
        }
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minite);
        calendar.set(13, second);
        calendar.set(14, (int)miliSecond);
        calendar.set(15, timeZoneOffSet);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private static int[] getTimeZoneWithMilliSeconds(String fractionStr) {
        int miliSecond = 0;
        int timeZoneOffSet = -1;
        if (fractionStr.startsWith(".")) {
            int milliSecondPartLength = 0;
            if (fractionStr.endsWith("Z")) {
                timeZoneOffSet = 0;
                String fractionPart = fractionStr.substring(1, fractionStr.lastIndexOf("Z"));
                miliSecond = Integer.parseInt(fractionPart);
                milliSecondPartLength = fractionPart.trim().length();
            } else {
                int lastIndexOfPlus = fractionStr.lastIndexOf("+");
                int lastIndexofMinus = fractionStr.lastIndexOf("-");
                if (lastIndexOfPlus > 0 || lastIndexofMinus > 0) {
                    String fractionPart;
                    String timeOffSetStr = null;
                    if (lastIndexOfPlus > 0) {
                        timeOffSetStr = fractionStr.substring(lastIndexOfPlus + 1);
                        fractionPart = fractionStr.substring(1, lastIndexOfPlus);
                        miliSecond = Integer.parseInt(fractionPart);
                        milliSecondPartLength = fractionPart.trim().length();
                        timeZoneOffSet = 1;
                    } else if (lastIndexofMinus > 0) {
                        timeOffSetStr = fractionStr.substring(lastIndexofMinus + 1);
                        fractionPart = fractionStr.substring(1, lastIndexofMinus);
                        miliSecond = Integer.parseInt(fractionPart);
                        milliSecondPartLength = fractionPart.trim().length();
                        timeZoneOffSet = -1;
                    }
                    if (timeOffSetStr != null) {
                        if (timeOffSetStr.charAt(2) != ':') {
                            throw new BallerinaException("invalid time zone format: " + fractionStr);
                        }
                        int hours = Integer.parseInt(timeOffSetStr.substring(0, 2));
                        int minits = Integer.parseInt(timeOffSetStr.substring(3, 5));
                        timeZoneOffSet = (hours * 60 + minits) * 60000 * timeZoneOffSet;
                    }
                } else {
                    miliSecond = Integer.parseInt(fractionStr.substring(1));
                    milliSecondPartLength = fractionStr.substring(1).trim().length();
                }
            }
            if (milliSecondPartLength != 3) {
                miliSecond *= 1000;
                for (int i = 0; i < milliSecondPartLength; ++i) {
                    miliSecond /= 10;
                }
            }
        } else {
            timeZoneOffSet = SQLDatasourceUtils.getTimeZoneOffset(fractionStr);
        }
        return new int[]{miliSecond, timeZoneOffSet};
    }

    private static int getTimeZoneOffset(String timezoneStr) {
        int timeZoneOffSet;
        if (timezoneStr.startsWith("Z")) {
            timeZoneOffSet = 0;
        } else if (timezoneStr.startsWith("+") || timezoneStr.startsWith("-")) {
            if (timezoneStr.charAt(3) != ':') {
                throw new BallerinaException("invalid time zone format:" + timezoneStr);
            }
            int hours = Integer.parseInt(timezoneStr.substring(1, 3));
            int minits = Integer.parseInt(timezoneStr.substring(4, 6));
            timeZoneOffSet = (hours * 60 + minits) * 60000;
            if (timezoneStr.startsWith("-")) {
                timeZoneOffSet *= -1;
            }
        } else {
            throw new BallerinaException("invalid prefix for timezone: " + timezoneStr);
        }
        return timeZoneOffSet;
    }
}

