/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.builtin.jsonlib;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.lang.utils.ErrorHandler;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.builtin", functionName="json.getKeys", args={@Argument(name="j", type=TypeKind.JSON)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.STRING)}, isPublic=true)
public class GetKeys
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(GetKeys.class);

    public BValue[] execute(Context ctx) {
        BStringArray keys = null;
        try {
            BJSON json = (BJSON)this.getRefArgument(ctx, 0);
            keys = JSONUtils.getKeys((BJSON)json);
            if (log.isDebugEnabled()) {
                log.debug("keys: " + keys);
            }
        }
        catch (Throwable e) {
            ErrorHandler.handleJsonException("get keys from json", e);
        }
        return this.getBValues(new BValue[]{keys});
    }
}

