/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.builtin.jsonlib;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.lang.utils.ErrorHandler;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.builtin", functionName="json.toString", args={@Argument(name="j", type=TypeKind.JSON)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class ToString
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(ToString.class);

    public BValue[] execute(Context ctx) {
        String jsonStr = null;
        try {
            BJSON json = (BJSON)this.getRefArgument(ctx, 0);
            jsonStr = json.stringValue();
            if (log.isDebugEnabled()) {
                log.debug("Output JSON: " + jsonStr);
            }
        }
        catch (Throwable e) {
            ErrorHandler.handleJsonException("convert json to string", e);
        }
        return this.getBValues(new BValue[]{new BString(jsonStr)});
    }
}

