/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.builtin.jsonlib;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.nativeimpl.lang.utils.ErrorHandler;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(packageName="ballerina.builtin", functionName="json.toXML", args={@Argument(name="j", type=TypeKind.JSON), @Argument(name="options", type=TypeKind.STRUCT, structType="Options", structPackage="ballerina.builtin")}, returnType={@ReturnType(type=TypeKind.XML)}, isPublic=true)
public class ToXML
extends AbstractNativeFunction {
    public BValue[] execute(Context ctx) {
        BXML xml = null;
        try {
            BJSON json = (BJSON)this.getRefArgument(ctx, 0);
            BStruct optionsStruct = (BStruct)this.getRefArgument(ctx, 1);
            String attributePrefix = optionsStruct.getStringField(0);
            String arrayEntryTag = optionsStruct.getStringField(1);
            xml = JSONUtils.convertToXML((BJSON)json, (String)attributePrefix, (String)arrayEntryTag);
        }
        catch (Throwable e) {
            ErrorHandler.handleJsonException("convert json to xml", e);
        }
        return this.getBValues(new BValue[]{xml});
    }
}

