/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.builtin.stringlib;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;

@BallerinaFunction(packageName="ballerina.builtin", functionName="string.subString", args={@Argument(name="mainString", type=TypeKind.STRING), @Argument(name="from", type=TypeKind.INT), @Argument(name="to", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class SubString
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        String initialString = this.getStringArgument(context, 0);
        long fromLong = this.getIntArgument(context, 0);
        long toLong = this.getIntArgument(context, 1);
        if (toLong != (long)((int)toLong)) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{toLong});
        }
        if (fromLong != (long)((int)fromLong)) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{fromLong});
        }
        int from = (int)fromLong;
        int to = (int)toLong;
        if (from < 0 || to > initialString.length()) {
            throw new BallerinaException("String index out of range. Actual:" + initialString.length() + " requested: " + from + " to " + to);
        }
        BString subString = new BString(initialString.substring(from, to));
        return this.getBValues(new BValue[]{subString});
    }
}

