/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.builtin.xmllib;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.nativeimpl.lang.utils.ErrorHandler;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(packageName="ballerina.builtin", functionName="xml.toJSON", args={@Argument(name="options", type=TypeKind.STRUCT, structType="Options", structPackage="ballerina.lang.xmls")}, returnType={@ReturnType(type=TypeKind.JSON)}, isPublic=true)
public class ToJSON
extends AbstractNativeFunction {
    public BValue[] execute(Context ctx) {
        BJSON json = null;
        try {
            BXML xml = (BXML)this.getRefArgument(ctx, 0);
            BStruct optionsStruct = (BStruct)this.getRefArgument(ctx, 1);
            String attributePrefix = optionsStruct.getStringField(0);
            Boolean preserveNamespaces = optionsStruct.getBooleanField(0) == 1;
            json = XMLUtils.convertToJSON((BXML)xml, (String)attributePrefix, (boolean)preserveNamespaces);
        }
        catch (Throwable e) {
            ErrorHandler.handleXMLException("convert xml to json", e);
        }
        return this.getBValues(new BValue[]{json});
    }
}

