/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.file", functionName="close", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), args={@Argument(name="file", type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file")}, isPublic=true)
public class Close
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(Close.class);

    public BValue[] execute(Context context) {
        BStruct struct = (BStruct)this.getRefArgument(context, 0);
        BufferedInputStream is = (BufferedInputStream)struct.getNativeData("inStream");
        BufferedOutputStream os = (BufferedOutputStream)struct.getNativeData("outStream");
        this.closeQuietly(is);
        this.closeQuietly(os);
        return VOID_RETURN;
    }

    private void closeQuietly(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException e) {
            log.error("Exception during Resource.close()", (Throwable)e);
        }
    }
}

