/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.file.utils.FileUtils;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.file", functionName="createNewFile", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), returnType={@ReturnType(type=TypeKind.BOOLEAN), @ReturnType(type=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class CreateNewFile
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(CreateNewFile.class);

    public BValue[] execute(Context context) {
        Path newFile;
        BStruct fileStruct = (BStruct)this.getRefArgument(context, 0);
        Path filePath = Paths.get(fileStruct.getStringField(0), new String[0]);
        try {
            newFile = Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            String msg = "Failed to create the file: " + filePath.toString();
            log.error(msg, (Throwable)e);
            return this.getBValues(new BValue[]{new BBoolean(false), null, FileUtils.createIOError(context, msg)});
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + filePath.toString();
            log.error(msg, (Throwable)e);
            return this.getBValues(new BValue[]{new BBoolean(false), FileUtils.createAccessDeniedError(context, msg), null});
        }
        return this.getBValues(new BValue[]{new BBoolean(Files.exists(newFile, new LinkOption[0])), null, null});
    }
}

