/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.File;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.file", functionName="delete", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), args={@Argument(name="target", type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file")}, isPublic=true)
public class Delete
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        BStruct target = (BStruct)this.getRefArgument(context, 0);
        File targetFile = new File(target.getStringField(0));
        if (!targetFile.exists()) {
            throw new BallerinaException("failed to delete file: file not found: " + targetFile.getPath());
        }
        if (!this.delete(targetFile)) {
            throw new BallerinaException("failed to delete file: " + targetFile.getPath());
        }
        return VOID_RETURN;
    }

    private boolean delete(File targetFile) {
        String[] entries = targetFile.list();
        if (entries != null && entries.length != 0) {
            for (String s : entries) {
                File currentFile = new File(targetFile.getPath(), s);
                if (currentFile.isDirectory()) {
                    this.delete(currentFile);
                    continue;
                }
                if (currentFile.delete()) continue;
                return false;
            }
        }
        return targetFile.delete();
    }
}

