/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.file.utils.FileUtils;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.file", functionName="getModifiedTime", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), returnType={@ReturnType(type=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class GetModifiedTime
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(GetModifiedTime.class);

    public BValue[] execute(Context context) {
        BStruct lastModifiedStruct;
        BStruct fileStruct = (BStruct)this.getRefArgument(context, 0);
        String path = fileStruct.getStringField(0);
        try {
            FileTime lastModified = Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]);
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(lastModified.toString());
            lastModifiedStruct = FileUtils.createTimeStruct(context, zonedDateTime, lastModified.toMillis());
        }
        catch (IOException e) {
            String msg = "Error in reading file: " + path;
            log.error(msg, (Throwable)e);
            return this.getBValues(new BValue[]{null, null, FileUtils.createIOError(context, msg)});
        }
        catch (SecurityException e) {
            String msg = "Read permission denied for file: " + path;
            log.error(msg, (Throwable)e);
            return this.getBValues(new BValue[]{null, FileUtils.createAccessDeniedError(context, msg), null});
        }
        return this.getBValues(new BValue[]{lastModifiedStruct, null, null});
    }
}

