/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.file.utils.FileUtils;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.file", functionName="list", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class ListFiles
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(ListFiles.class);

    public BValue[] execute(Context context) {
        BRefValueArray filesList;
        BStruct fileStruct = (BStruct)this.getRefArgument(context, 0);
        String path = fileStruct.getStringField(0);
        ArrayList structList = new ArrayList();
        try {
            Files.list(Paths.get(path, new String[0])).forEach(p -> structList.add(FileUtils.createFileStruct(context, p.toString())));
            filesList = new BRefValueArray(structList.toArray(new BRefType[0]), (BType)fileStruct.getType());
        }
        catch (IOException e) {
            String msg = "Error occurred while opening directory: " + path;
            log.error(msg, (Throwable)e);
            return this.getBValues(new BValue[]{null, null, FileUtils.createIOError(context, msg)});
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Could not open directory: " + path;
            log.error(msg, (Throwable)e);
            return this.getBValues(new BValue[]{null, FileUtils.createAccessDeniedError(context, msg), null});
        }
        return this.getBValues(new BValue[]{filesList, null, null});
    }
}

