/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.File;
import java.nio.file.Paths;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.file.utils.FileUtils;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.file", functionName="mkdirs", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), returnType={@ReturnType(type=TypeKind.BOOLEAN), @ReturnType(type=TypeKind.STRUCT), @ReturnType(type=TypeKind.STRUCT)}, isPublic=true)
public class Mkdirs
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(Mkdirs.class);

    public BValue[] execute(Context context) {
        boolean dirCreated;
        BStruct fileStruct = (BStruct)this.getRefArgument(context, 0);
        String path = fileStruct.getStringField(0);
        File dir = Paths.get(path, new String[0]).toFile();
        try {
            dirCreated = dir.mkdirs();
        }
        catch (SecurityException e) {
            log.error("Could not create directory structure: " + path, (Throwable)e);
            return this.getBValues(new BValue[]{new BBoolean(false), null, FileUtils.createIOError(context, "Could not create the requested directory structure: " + path)});
        }
        return dirCreated ? this.getBValues(new BValue[]{new BBoolean(true), null, null}) : this.getBValues(new BValue[]{new BBoolean(false), FileUtils.createAccessDeniedError(context, "Permission denied to create the requested directory structure: " + path), null});
    }
}

