/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.File;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.file", functionName="move", args={@Argument(name="source", type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), @Argument(name="destination", type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file")}, isPublic=true)
public class Move
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        BStruct source = (BStruct)this.getRefArgument(context, 0);
        BStruct destination = (BStruct)this.getRefArgument(context, 1);
        File sourceFile = new File(source.getStringField(0));
        if (!sourceFile.exists()) {
            throw new BallerinaException("failed to move file: file not found: " + sourceFile.getPath());
        }
        File destinationFile = new File(destination.getStringField(0));
        File parent = destinationFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new BallerinaException("failed to move file: cannot create directory: " + parent.getPath());
        }
        if (!sourceFile.renameTo(destinationFile)) {
            throw new BallerinaException("failed to move file: " + sourceFile.getPath());
        }
        return VOID_RETURN;
    }
}

