/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(packageName="ballerina.file", functionName="open", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), args={@Argument(name="file", type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), @Argument(name="accessMode", type=TypeKind.STRING)}, isPublic=true)
public class Open
extends AbstractNativeFunction {
    private static final Logger log = LoggerFactory.getLogger(Open.class);

    public BValue[] execute(Context context) {
        BStruct struct = (BStruct)this.getRefArgument(context, 0);
        String accessMode = this.getStringArgument(context, 0);
        try {
            File file = new File(struct.getStringField(0));
            String accessLC = accessMode.toLowerCase(Locale.getDefault());
            if (accessLC.contains("r")) {
                if (!file.exists()) {
                    throw new BallerinaException("file not found: " + file.getPath());
                }
                if (!file.canRead()) {
                    throw new BallerinaException("file is not readable: " + file.getPath());
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                struct.addNativeData("inStream", (Object)is);
            }
            boolean write = accessLC.contains("w");
            boolean append = accessLC.contains("a");
            if (!write && !append) {
                return VOID_RETURN;
            }
            if (write && append) {
                log.info("found both 'a' and 'w' in access mode string. opening file in append mode");
            }
            if (file.exists() && !file.canWrite()) {
                throw new BallerinaException("file is not writable: " + file.getPath());
            }
            this.createDirs(file);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, append));
            struct.addNativeData("outStream", (Object)os);
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to open file: " + e.getMessage(), e);
        }
        return VOID_RETURN;
    }

    private void createDirs(File destinationFile) {
        File parent = destinationFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new BallerinaException("Error in writing file");
        }
    }
}

