/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.nativeimpl.io.channels.AbstractNativeChannel;
import org.ballerinalang.nativeimpl.io.channels.FileIOChannel;
import org.ballerinalang.nativeimpl.io.channels.base.AbstractChannel;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.file", functionName="openChannel", receiver=@Receiver(type=TypeKind.STRUCT, structType="File", structPackage="ballerina.file"), args={@Argument(name="accessMode", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="ByteChannel", structPackage="ballerina.io")}, isPublic=true)
public class OpenChannel
extends AbstractNativeChannel {
    private static final int FILE_CHANNEL_INDEX = 0;
    private static final int FILE_ACCESS_MODE_INDEX = 0;
    private static final int PATH_FIELD_INDEX = 0;

    private void createDirs(Path path) {
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BallerinaException("Error in writing file", (Throwable)e);
            }
        }
    }

    @Override
    public AbstractChannel inFlow(Context context) throws BallerinaException {
        FileIOChannel channel;
        BStruct fileStruct = (BStruct)this.getRefArgument(context, 0);
        String accessMode = this.getStringArgument(context, 0);
        Path path = null;
        try {
            String accessLC = accessMode.toLowerCase(Locale.getDefault());
            path = Paths.get(fileStruct.getStringField(0), new String[0]);
            HashSet<StandardOpenOption> opts = new HashSet<StandardOpenOption>();
            if (accessLC.contains("r")) {
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new BallerinaException("file not found: " + path);
                }
                if (!Files.isReadable(path)) {
                    throw new BallerinaException("file is not readable: " + path);
                }
                opts.add(StandardOpenOption.READ);
            }
            boolean write = accessLC.contains("w");
            boolean append = accessLC.contains("a");
            if (write || append) {
                if (Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
                    throw new BallerinaException("file is not writable: " + path);
                }
                this.createDirs(path);
                opts.add(StandardOpenOption.CREATE);
                if (append) {
                    opts.add(StandardOpenOption.APPEND);
                } else {
                    opts.add(StandardOpenOption.WRITE);
                }
            }
            FileChannel byteChannel = FileChannel.open(path, opts, new FileAttribute[0]);
            channel = new FileIOChannel(byteChannel, 16384);
        }
        catch (AccessDeniedException e) {
            throw new BallerinaException("Do not have access to write file: " + path, (Throwable)e);
        }
        catch (Throwable e) {
            throw new BallerinaException("failed to open file: " + e.getMessage(), e);
        }
        return channel;
    }
}

