/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.file.utils;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;

public class FileUtils {
    public static BStruct createFileStruct(Context context, String path) {
        PackageInfo filePkg = context.getProgramFile().getPackageInfo("ballerina.file");
        StructInfo fileInfo = filePkg.getStructInfo("File");
        return BLangVMStructs.createBStruct((StructInfo)fileInfo, (Object[])new Object[]{path});
    }

    public static BStruct createAccessDeniedError(Context context, String msg) {
        PackageInfo filePkg = context.getProgramFile().getPackageInfo("ballerina.file");
        StructInfo accessErrInfo = filePkg.getStructInfo("AccessDeniedError");
        return BLangVMStructs.createBStruct((StructInfo)accessErrInfo, (Object[])new Object[]{msg});
    }

    public static BStruct createIOError(Context context, String msg) {
        PackageInfo filePkg = context.getProgramFile().getPackageInfo("ballerina.file");
        StructInfo ioErrInfo = filePkg.getStructInfo("IOError");
        return BLangVMStructs.createBStruct((StructInfo)ioErrInfo, (Object[])new Object[]{msg});
    }

    public static BStruct createTimeStruct(Context context, ZonedDateTime time, long millis) {
        BStruct timezone = FileUtils.createTimeZone(context, time.getZone());
        return BLangVMStructs.createBStruct((StructInfo)FileUtils.getTimeStructInfo(context), (Object[])new Object[]{millis, timezone});
    }

    private static BStruct createTimeZone(Context context, ZoneId zoneId) {
        String zoneIdName = zoneId.toString();
        TimeZone tz = TimeZone.getTimeZone(zoneId);
        int offsetInMills = tz.getOffset(new Date().getTime());
        int offset = offsetInMills / 1000;
        return BLangVMStructs.createBStruct((StructInfo)FileUtils.getTimeZoneStructInfo(context), (Object[])new Object[]{zoneIdName, offset});
    }

    private static StructInfo getTimeStructInfo(Context context) {
        PackageInfo timePackageInfo = context.getProgramFile().getPackageInfo("ballerina.builtin");
        return timePackageInfo.getStructInfo("Time");
    }

    private static StructInfo getTimeZoneStructInfo(Context context) {
        PackageInfo timePackageInfo = context.getProgramFile().getPackageInfo("ballerina.builtin");
        return timePackageInfo.getStructInfo("Timezone");
    }
}

