/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.Channel;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.io", functionName="readAllBytes", receiver=@Receiver(type=TypeKind.STRUCT, structType="ByteChannel", structPackage="ballerina.io"), returnType={@ReturnType(type=TypeKind.BLOB), @ReturnType(type=TypeKind.INT)}, isPublic=true)
public class ReadAllBytes
extends AbstractNativeFunction {
    private static final int BYTE_CHANNEL_INDEX = 0;

    public BValue[] execute(Context context) {
        BInteger numberOfReadBytes;
        BBlob readByteBlob;
        try {
            BStruct channel = (BStruct)this.getRefArgument(context, 0);
            Channel byteChannel = (Channel)channel.getNativeData("channel");
            byte[] readBytes = byteChannel.readAll();
            readByteBlob = new BBlob(readBytes);
            numberOfReadBytes = new BInteger((long)readBytes.length);
        }
        catch (Throwable e) {
            String message = "Error occurred while reading bytes:" + e.getMessage();
            throw new BallerinaException(message, context);
        }
        return this.getBValues(new BValue[]{readByteBlob, numberOfReadBytes});
    }
}

