/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.CharacterChannel;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.io", functionName="readAllCharacters", receiver=@Receiver(type=TypeKind.STRUCT, structType="CharacterChannel", structPackage="ballerina.io"), returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class ReadAllCharacters
extends AbstractNativeFunction {
    private static final int CHAR_CHANNEL_INDEX = 0;

    public BValue[] execute(Context context) {
        BString content;
        try {
            BStruct channel = (BStruct)this.getRefArgument(context, 0);
            CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
            String readBytes = characterChannel.readAll();
            content = new BString(readBytes);
        }
        catch (Throwable e) {
            String message = "Error occurred while reading characters:" + e.getMessage();
            throw new BallerinaException(message, context);
        }
        return this.getBValues(new BValue[]{content});
    }
}

