/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.TextRecordChannel;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.io", functionName="readTextRecord", receiver=@Receiver(type=TypeKind.STRUCT, structType="TextRecordChannel", structPackage="ballerina.io"), returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.STRING)}, isPublic=true)
public class ReadTextRecord
extends AbstractNativeFunction {
    private static final int TXT_RECORD_CHANNEL_INDEX = 0;

    public BValue[] execute(Context context) {
        BStringArray record;
        try {
            BStruct channel = (BStruct)this.getRefArgument(context, 0);
            TextRecordChannel textRecordChannel = (TextRecordChannel)channel.getNativeData("txt_record");
            String[] recordValue = textRecordChannel.read();
            record = new BStringArray(recordValue);
        }
        catch (Throwable e) {
            String message = "Error occurred while reading text records:" + e.getMessage();
            throw new BallerinaException(message, context);
        }
        return this.getBValues(new BValue[]{record});
    }
}

