/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.AbstractChannel;
import org.ballerinalang.nativeimpl.io.channels.base.CharacterChannel;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.io", functionName="toCharacterChannel", receiver=@Receiver(type=TypeKind.STRUCT, structType="ByteChannel", structPackage="ballerina.io"), args={@Argument(name="encoding", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="CharacterChannel", structPackage="ballerina.io")}, isPublic=true)
public class ToCharacterChannel
extends AbstractNativeFunction {
    private static final int CHAR_CHANNEL_INDEX = 0;
    private static final int ENCODING_INDEX = 0;
    private StructInfo characterChannelStructInfo;
    private static final String CHAR_CHANNEL_PACKAGE = "ballerina.io";
    private static final String STRUCT_TYPE = "CharacterChannel";

    private StructInfo getCharacterChannelStructInfo(Context context) {
        StructInfo result = this.characterChannelStructInfo;
        if (result == null) {
            PackageInfo timePackageInfo = context.getProgramFile().getPackageInfo(CHAR_CHANNEL_PACKAGE);
            this.characterChannelStructInfo = timePackageInfo.getStructInfo(STRUCT_TYPE);
        }
        return this.characterChannelStructInfo;
    }

    public BValue[] execute(Context context) {
        BValue[] bValues;
        try {
            BStruct characterChannelInfo = (BStruct)this.getRefArgument(context, 0);
            String encoding = this.getStringArgument(context, 0);
            BStruct characterChannel = BLangVMStructs.createBStruct((StructInfo)this.getCharacterChannelStructInfo(context), (Object[])new Object[0]);
            AbstractChannel byteChannel = (AbstractChannel)characterChannelInfo.getNativeData("channel");
            CharacterChannel bCharacterChannel = new CharacterChannel(byteChannel, encoding);
            characterChannel.addNativeData("char_channel", (Object)bCharacterChannel);
            bValues = this.getBValues(new BValue[]{characterChannel});
        }
        catch (Throwable e) {
            String message = "Error occurred while converting byte channel to character channel:" + e.getMessage();
            throw new BallerinaException(message, context);
        }
        return bValues;
    }
}

