/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.CharacterChannel;
import org.ballerinalang.nativeimpl.io.channels.base.TextRecordChannel;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.io", functionName="toTextRecordChannel", receiver=@Receiver(type=TypeKind.STRUCT, structType="CharacterChannel", structPackage="ballerina.io"), args={@Argument(name="recordSeparator", type=TypeKind.STRING), @Argument(name="fieldSeparator", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="TextRecordChannel", structPackage="ballerina.io")}, isPublic=true)
public class ToTextRecordChannel
extends AbstractNativeFunction {
    private static final int TXT_RECORD_CHANNEL_INDEX = 0;
    private static final int RECORD_SEPARATOR_INDEX = 0;
    private static final int FIELD_SEPARATOR_INDEX = 1;
    private StructInfo textRecordChannelStructInfo;
    private static final String TXT_RECORD_CHANNEL_PACKAGE = "ballerina.io";
    private static final String STRUCT_TYPE = "TextRecordChannel";

    private StructInfo getCharacterChannelStructInfo(Context context) {
        StructInfo result = this.textRecordChannelStructInfo;
        if (result == null) {
            PackageInfo timePackageInfo = context.getProgramFile().getPackageInfo(TXT_RECORD_CHANNEL_PACKAGE);
            this.textRecordChannelStructInfo = timePackageInfo.getStructInfo(STRUCT_TYPE);
        }
        return this.textRecordChannelStructInfo;
    }

    public BValue[] execute(Context context) {
        BValue[] bValues;
        try {
            BStruct textRecordChannelInfo = (BStruct)this.getRefArgument(context, 0);
            String recordSeparator = this.getStringArgument(context, 0);
            String fieldSeparator = this.getStringArgument(context, 1);
            BStruct textRecordChannel = BLangVMStructs.createBStruct((StructInfo)this.getCharacterChannelStructInfo(context), (Object[])new Object[0]);
            CharacterChannel characterChannel = (CharacterChannel)textRecordChannelInfo.getNativeData("char_channel");
            TextRecordChannel bCharacterChannel = new TextRecordChannel(characterChannel, recordSeparator, fieldSeparator);
            textRecordChannel.addNativeData("txt_record", (Object)bCharacterChannel);
            bValues = this.getBValues(new BValue[]{textRecordChannel});
        }
        catch (Throwable e) {
            String message = "Error occurred while converting character channel to textRecord channel:" + e.getMessage();
            throw new BallerinaException(message, context);
        }
        return bValues;
    }
}

