/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.nativeimpl.io.channels.base.Channel;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.io", functionName="writeBytes", receiver=@Receiver(type=TypeKind.STRUCT, structType="ByteChannel", structPackage="ballerina.io"), args={@Argument(name="content", type=TypeKind.BLOB), @Argument(name="startOffset", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.INT)}, isPublic=true)
public class WriteBytes
extends AbstractNativeFunction {
    private static final int BYTE_CHANNEL_INDEX = 0;
    private static final int CONTENT_INDEX = 0;
    private static final int START_OFFSET_INDEX = 0;

    public BValue[] execute(Context context) {
        int numberOfBytesWritten;
        try {
            BStruct channel = (BStruct)this.getRefArgument(context, 0);
            byte[] content = this.getBlobArgument(context, 0);
            int startOffset = (int)this.getIntArgument(context, 0);
            Channel byteChannel = (Channel)channel.getNativeData("channel");
            numberOfBytesWritten = byteChannel.write(content, startOffset);
        }
        catch (Throwable e) {
            String message = "Error occurred while writing bytes:" + e.getMessage();
            throw new BallerinaException(message, context);
        }
        return this.getBValues(new BValue[]{new BInteger((long)numberOfBytesWritten)});
    }
}

