/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io.channels.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.WritableByteChannel;
import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannel {
    private ByteChannel channel;
    private boolean hasReachedToEnd = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractChannel.class);

    public AbstractChannel(ByteChannel channel) throws BallerinaIOException {
        if (null != channel) {
            this.channel = channel;
            if (log.isDebugEnabled()) {
                log.debug("Initializing ByteChannel with ref id " + channel.hashCode());
            }
        } else {
            String message = "The provided information is incorrect, the specified channel ";
            throw new BallerinaIOException(message);
        }
    }

    public abstract void transfer(int var1, int var2, WritableByteChannel var3) throws BallerinaIOException;

    void readFromChannel(ByteBuffer inputBuffer) throws BallerinaIOException {
        try {
            if (!this.hasReachedToEnd) {
                if (log.isDebugEnabled()) {
                    log.debug("Reading from channel " + this.channel.hashCode());
                }
                int numberOfReadBytes = 0;
                int channelEndOfStreamFlag = -1;
                while (inputBuffer.hasRemaining() && numberOfReadBytes > channelEndOfStreamFlag) {
                    numberOfReadBytes = this.channel.read(inputBuffer);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Read from channel " + numberOfReadBytes + " from " + this.channel.hashCode());
                }
                if (numberOfReadBytes == channelEndOfStreamFlag) {
                    if (log.isDebugEnabled()) {
                        log.debug("The channel " + this.channel.hashCode() + " reached EoF");
                    }
                    this.hasReachedToEnd = true;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("The channel " + this.channel.hashCode() + " reached EoF hence  will not be get from the " + "channel");
            }
        }
        catch (IOException e) {
            String message = "Error occurred while reading from channel ";
            throw new BallerinaIOException(message, e);
        }
    }

    int write(ByteBuffer contentBuffer) throws BallerinaIOException {
        int numberOfBytesWritten;
        try {
            while (contentBuffer.hasRemaining()) {
                int write = this.channel.write(contentBuffer);
                if (!log.isTraceEnabled()) continue;
                log.trace("Number of bytes " + write + " written to channel " + this.channel.hashCode());
            }
            numberOfBytesWritten = contentBuffer.position();
            if (log.isDebugEnabled()) {
                log.debug("Number of bytes " + numberOfBytesWritten + " to the channel " + this.channel.hashCode());
            }
        }
        catch (IOException e) {
            String message = "Error occurred while writing to channel ";
            throw new BallerinaIOException(message, e);
        }
        return numberOfBytesWritten;
    }

    public void close() {
        try {
            if (null != this.channel) {
                this.channel.close();
            } else {
                log.error("The channel has already being closed.");
            }
        }
        catch (IOException e) {
            String message = "Error occurred while closing the connection. ";
            throw new BallerinaIOException(message, e);
        }
    }
}

