/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io.channels.base;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.ballerinalang.nativeimpl.io.channels.base.AbstractChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffer {
    private ByteBuffer byteBuffer;
    private int minimumSizeOfBuffer;
    private static final Logger log = LoggerFactory.getLogger(Buffer.class);

    public Buffer(int minimumSizeOfBuffer) {
        this.minimumSizeOfBuffer = minimumSizeOfBuffer;
    }

    private ByteBuffer getBytesLeftInBuffer(int totalNumberOfBytesRequired) {
        ByteBuffer bufferedContent = null;
        if (null != this.byteBuffer) {
            int position = this.byteBuffer.position();
            int limit = this.byteBuffer.limit();
            int numberOfBytesRemainingInBuffer = limit - position;
            if (numberOfBytesRemainingInBuffer == 0) {
                return null;
            }
            if (numberOfBytesRemainingInBuffer > totalNumberOfBytesRequired) {
                limit = position + totalNumberOfBytesRequired;
            }
            byte[] content = Arrays.copyOfRange(this.byteBuffer.array(), position, limit);
            int readBufferPosition = position + content.length;
            bufferedContent = ByteBuffer.wrap(content);
            this.byteBuffer.position(readBufferPosition);
            bufferedContent.position(bufferedContent.limit());
        } else if (log.isDebugEnabled()) {
            log.debug("ByteBuffer has not being initialized, buffer will be initialized while reading the requested amount of " + totalNumberOfBytesRequired + " of bytes");
        }
        return bufferedContent;
    }

    private ByteBuffer allocate(int size) {
        if (size < this.minimumSizeOfBuffer) {
            size = this.minimumSizeOfBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    private ByteBuffer compactBytes(ByteBuffer srcBuffer) {
        ByteBuffer response;
        int bufferReadPosition;
        int bufferSize = srcBuffer.capacity();
        if (bufferSize > (bufferReadPosition = srcBuffer.position())) {
            byte[] resizedContent = Arrays.copyOfRange(srcBuffer.array(), 0, bufferReadPosition);
            response = ByteBuffer.wrap(resizedContent);
            response.position(response.limit());
        } else {
            response = srcBuffer;
        }
        return response;
    }

    private ByteBuffer getBytesFromChannel(int requiredNumberOfBytes, int offset, AbstractChannel channel) throws BallerinaIOException {
        int numberOfBytesRequiredFromChannel = requiredNumberOfBytes - offset;
        ByteBuffer srcBuffer = this.allocate(numberOfBytesRequiredFromChannel);
        channel.readFromChannel(srcBuffer);
        return this.compactBytes(srcBuffer);
    }

    private boolean isBufferEmpty(ByteBuffer srcBuffer) {
        return srcBuffer.limit() == 0;
    }

    private ByteBuffer consolidate(int size, ByteBuffer ... values) {
        ByteBuffer consolidatedByteBuffer = ByteBuffer.allocate(size);
        for (ByteBuffer value : values) {
            if (null == value || this.isBufferEmpty(value)) continue;
            value.flip();
            consolidatedByteBuffer.put(value);
        }
        return consolidatedByteBuffer;
    }

    private ByteBuffer resizeIfRequired(ByteBuffer srcBuffer, int size) {
        int capacity = srcBuffer.capacity();
        if (capacity < size) {
            size = capacity;
        }
        byte[] resizedContent = Arrays.copyOfRange(srcBuffer.array(), 0, size);
        ByteBuffer resizedBuffer = ByteBuffer.wrap(resizedContent);
        this.byteBuffer.position(resizedContent.length);
        return resizedBuffer;
    }

    public void reverse(int count) throws BallerinaIOException {
        int reversedByteBufferPosition;
        if (null != this.byteBuffer) {
            reversedByteBufferPosition = this.byteBuffer.position() - count;
            boolean minimumBytePosition = false;
            if (reversedByteBufferPosition < 0) {
                String message = "The specified byte count " + count + " has not being read,hence cannot reverse";
                throw new BallerinaIOException(message);
            }
        } else {
            String message = "ByteBuffer not initialized, please initialize it before reversing";
            log.error(message);
            throw new BallerinaIOException(message);
        }
        this.byteBuffer.position(reversedByteBufferPosition);
    }

    public ByteBuffer get(int numberOfBytesRequested, AbstractChannel channel) throws BallerinaIOException {
        int numberOfBytesReadFromBuffer;
        ByteBuffer remainingBytesInBuffer = this.getBytesLeftInBuffer(numberOfBytesRequested);
        int n = numberOfBytesReadFromBuffer = remainingBytesInBuffer != null ? remainingBytesInBuffer.capacity() : 0;
        if (numberOfBytesReadFromBuffer == numberOfBytesRequested) {
            return remainingBytesInBuffer;
        }
        ByteBuffer bytesReadFromChannel = this.getBytesFromChannel(numberOfBytesRequested, numberOfBytesReadFromBuffer, channel);
        int numberOfBytesReadFromChannel = bytesReadFromChannel.capacity();
        int consolidatedBufferSize = numberOfBytesReadFromChannel + numberOfBytesReadFromBuffer;
        this.byteBuffer = this.consolidate(consolidatedBufferSize, remainingBytesInBuffer, bytesReadFromChannel);
        return this.resizeIfRequired(this.byteBuffer, numberOfBytesRequested);
    }
}

