/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io.channels.base;

import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.ballerinalang.nativeimpl.io.channels.base.AbstractChannel;
import org.ballerinalang.nativeimpl.io.channels.base.Buffer;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Channel
extends AbstractChannel {
    private Buffer contentBuffer;
    private static final int MAX_BUFFER_CHUNK_SIZE = 1024;
    private static final Logger log = LoggerFactory.getLogger(Channel.class);

    public Channel(ByteChannel channel, int size) throws BallerinaIOException {
        super(channel);
        this.contentBuffer = new Buffer(size);
    }

    private byte[] merge(List<ByteBuffer> bufferList, int size) {
        ByteBuffer consolidatedBuffer = ByteBuffer.allocate(size);
        for (ByteBuffer buffer : bufferList) {
            consolidatedBuffer.put(buffer);
        }
        return consolidatedBuffer.array();
    }

    public byte[] read(int numberOfBytes) throws BallerinaIOException {
        ByteBuffer readBuffer = this.contentBuffer.get(numberOfBytes, this);
        return readBuffer.array();
    }

    public byte[] readAll() throws BallerinaException {
        ArrayList<ByteBuffer> readBufferList = new ArrayList<ByteBuffer>();
        int totalNumberOfBytes = 0;
        boolean hasRemaining = false;
        do {
            ByteBuffer readBuffer;
            int numberOfBytesRead;
            if ((numberOfBytesRead = (readBuffer = this.contentBuffer.get(1024, this)).limit()) > 0) {
                readBufferList.add(readBuffer);
                totalNumberOfBytes += numberOfBytesRead;
                continue;
            }
            hasRemaining = true;
        } while (!hasRemaining);
        return this.merge(readBufferList, totalNumberOfBytes);
    }

    public int write(byte[] content, int startOffset) throws BallerinaException {
        ByteBuffer outputBuffer = ByteBuffer.wrap(content);
        outputBuffer.position(startOffset);
        if (log.isDebugEnabled()) {
            log.debug("Writing " + content.length + " for the buffer with offset " + startOffset);
        }
        return this.write(outputBuffer);
    }
}

