/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io.channels.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.ballerinalang.nativeimpl.io.channels.base.AbstractChannel;
import org.ballerinalang.nativeimpl.io.channels.base.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterChannel {
    private static final Logger log = LoggerFactory.getLogger(CharacterChannel.class);
    private AbstractChannel channel;
    private CharsetDecoder bytesDecoder;
    private CharsetEncoder byteEncoder;
    private CharBuffer charBuffer;
    private Buffer contentBuffer;
    private static final char UN_MAPPABLE_CHARACTER = '\ufffd';
    private static final int MAX_BYTES_PER_CHAR = 3;
    private static final int MINIMUM_BYTE_BUFFER_SIZE = 0;
    private static final int MAX_CHAR_COUNT_PER_READ = 1024;

    public CharacterChannel(AbstractChannel channel, String encoding) {
        this.channel = channel;
        this.bytesDecoder = Charset.forName(encoding).newDecoder();
        this.byteEncoder = Charset.forName(encoding).newEncoder();
        this.contentBuffer = new Buffer(0);
        this.bytesDecoder.onMalformedInput(CodingErrorAction.REPLACE);
    }

    private int getNumberOfCharactersRemaining() {
        int limit = this.charBuffer.limit();
        int position = this.charBuffer.position();
        return limit - position;
    }

    private void appendCharsToString(StringBuilder content, int characterCount) {
        boolean indexCharacterOffset = false;
        char[] remainingChars = new char[characterCount];
        this.charBuffer.get(remainingChars, 0, characterCount);
        content.append(remainingChars);
        if (log.isTraceEnabled()) {
            log.trace("Characters appended to the string," + content);
        }
    }

    private void appendRemainingCharacters(StringBuilder content) {
        if (null != this.charBuffer) {
            int numberOfCharactersRemaining = this.getNumberOfCharactersRemaining();
            int numberOfCharsRequired = content.capacity();
            boolean minimumCharacterCount = false;
            if (log.isDebugEnabled()) {
                log.debug("Number of characters requested = " + numberOfCharsRequired + ",characters remaining in " + "buffer= " + numberOfCharactersRemaining);
            }
            if (numberOfCharsRequired < numberOfCharactersRemaining) {
                numberOfCharactersRemaining = numberOfCharsRequired;
            }
            if (numberOfCharactersRemaining > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Appending " + numberOfCharactersRemaining + " to the string.");
                }
                this.appendCharsToString(content, numberOfCharactersRemaining);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Character buffer has not being initialized yet for channel " + this.channel.hashCode());
        }
    }

    private boolean isMalformedCharacter(char character) {
        return character == '\ufffd';
    }

    private int getNumberOfBytesInContent(int length) {
        char[] availableContent = new char[length];
        this.charBuffer.get(availableContent, 0, length);
        byte[] bytes = new String(availableContent).getBytes(this.bytesDecoder.charset());
        this.charBuffer = CharBuffer.wrap(availableContent);
        return bytes.length;
    }

    private void readBytesIntoBufferFromChannel(int numberOfBytesRequired, int numberOfCharsRequired) throws CharacterCodingException {
        ByteBuffer byteBuffer = this.contentBuffer.get(numberOfBytesRequired, this.channel);
        this.charBuffer = this.bytesDecoder.decode(byteBuffer);
        int numberOfCharsProcessed = this.charBuffer.limit();
        boolean minimumNumberOfCharsRequired = false;
        if (numberOfCharsProcessed > 0) {
            int lastCharacterIndex = numberOfCharsProcessed - 1;
            char lastCharacterProcessed = this.charBuffer.get(lastCharacterIndex);
            if (numberOfCharsRequired < numberOfCharsProcessed && this.isMalformedCharacter(lastCharacterProcessed)) {
                int numberOfBytesWithoutTheLastChar = this.getNumberOfBytesInContent(lastCharacterIndex);
                int numberOfBytesAllocatedForLastChar = byteBuffer.capacity() - numberOfBytesWithoutTheLastChar;
                this.contentBuffer.reverse(numberOfBytesAllocatedForLastChar);
            }
        }
    }

    public String read(int numberOfCharacters) throws BallerinaIOException {
        StringBuilder content;
        try {
            content = new StringBuilder(numberOfCharacters);
            int numberOfBytesRequired = numberOfCharacters * 3;
            this.appendRemainingCharacters(content);
            int charsRequiredToBeReadFromChannel = content.capacity() - content.length();
            if (charsRequiredToBeReadFromChannel == 0) {
                return content.toString();
            }
            if (log.isDebugEnabled()) {
                log.debug("Number of chars required to be get from the channel " + charsRequiredToBeReadFromChannel);
            }
            this.readBytesIntoBufferFromChannel(numberOfBytesRequired, numberOfCharacters);
            if (this.charBuffer.limit() < charsRequiredToBeReadFromChannel) {
                charsRequiredToBeReadFromChannel = this.charBuffer.limit();
            }
            this.appendCharsToString(content, charsRequiredToBeReadFromChannel);
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while reading characters from buffer", e);
        }
        return content.toString();
    }

    public String readAll() {
        String value;
        StringBuilder response = new StringBuilder();
        do {
            value = this.read(1024);
            response.append(value);
        } while (!value.isEmpty());
        return response.toString();
    }

    public int write(String content, int offset) throws BallerinaIOException {
        try {
            int numberOfBytesWritten = -1;
            if (this.channel != null) {
                char[] characters = content.toCharArray();
                CharBuffer characterBuffer = CharBuffer.wrap(characters);
                characterBuffer.position(offset);
                ByteBuffer encodedBuffer = this.byteEncoder.encode(characterBuffer);
                numberOfBytesWritten = this.channel.write(encodedBuffer);
            } else {
                log.warn("The channel has already being closed");
            }
            return numberOfBytesWritten;
        }
        catch (CharacterCodingException e) {
            String message = "Error occurred while writing bytes to the channel " + this.channel.hashCode();
            throw new BallerinaIOException(message, e);
        }
    }

    public void close() {
        this.channel.close();
    }
}

