/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.io.channels.base;

import java.io.IOException;
import java.util.Arrays;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.nativeimpl.io.BallerinaIOException;
import org.ballerinalang.nativeimpl.io.channels.base.CharacterChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRecordChannel {
    private String recordSeparator;
    private String fieldSeparator;
    private StringBuilder persistentCharSequence;
    private int recordCharacterCount = 100;
    private CharacterChannel channel;
    private boolean remaining = true;
    private int numberOfRecordsReadThroughChannel = 0;
    private int numberOfRecordsWrittenToChannel = 0;
    private static final Logger log = LoggerFactory.getLogger(TextRecordChannel.class);

    public TextRecordChannel(CharacterChannel channel, String recordSeparator, String fieldSeparator) {
        this.recordSeparator = recordSeparator;
        this.fieldSeparator = fieldSeparator;
        this.channel = channel;
        this.persistentCharSequence = new StringBuilder();
    }

    private String readRecord() throws BallerinaIOException {
        String record = null;
        String readCharacters = "";
        boolean minimumRecordCount = true;
        int numberOfSplits = 2;
        do {
            String[] delimitedRecord;
            if (log.isTraceEnabled()) {
                log.trace("char[] remaining in memory " + this.persistentCharSequence);
            }
            if ((delimitedRecord = this.persistentCharSequence.toString().split(this.recordSeparator, 2)).length > 1) {
                record = this.processIdentifiedRecord(delimitedRecord);
                int recordCharacterLength = record.length();
                if (recordCharacterLength <= this.recordCharacterCount) continue;
                this.recordCharacterCount = record.length();
                continue;
            }
            readCharacters = this.readRecordFromChannel();
        } while (record == null && !readCharacters.isEmpty());
        if (null == record && readCharacters.isEmpty()) {
            record = this.readFinalRecord();
        }
        return record;
    }

    private String readFinalRecord() {
        boolean minimumRemainingLength = false;
        String record = "";
        if (log.isDebugEnabled()) {
            log.debug("The content returned from the channel " + this.channel.hashCode() + " is <void>");
        }
        this.remaining = false;
        if (this.persistentCharSequence.length() > 0) {
            record = this.persistentCharSequence.toString();
            if (log.isTraceEnabled()) {
                log.trace("char [] remaining in memory, will be marked as the last record " + record);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Final record is get from channel " + this.channel.hashCode() + " number of records get " + "from channel " + (this.numberOfRecordsReadThroughChannel + 1));
        }
        return record;
    }

    private String readRecordFromChannel() {
        String readCharacters = this.channel.read(this.recordCharacterCount);
        if (log.isTraceEnabled()) {
            log.trace("char [] get from channel," + this.channel.hashCode() + "=" + readCharacters);
        }
        this.persistentCharSequence.append(readCharacters);
        if (log.isTraceEnabled()) {
            log.trace("char [] appended to the memory " + this.persistentCharSequence);
        }
        return readCharacters;
    }

    private String processIdentifiedRecord(String[] delimitedRecords) {
        boolean minimumRemainingLength = false;
        boolean delimitedRecordIndex = false;
        boolean delimitedRemainingIndex = true;
        String recordContent = delimitedRecords[1];
        String record = delimitedRecords[0];
        this.persistentCharSequence.setLength(0);
        this.persistentCharSequence.append(recordContent);
        if (log.isTraceEnabled()) {
            log.trace("Record identified from remaining char[] in memory " + record);
            log.trace("The char[] left after split " + this.persistentCharSequence);
        }
        return record;
    }

    private String[] getFields(String record) {
        return record.split(this.fieldSeparator);
    }

    public String[] read() throws BallerinaIOException {
        boolean emptyArrayIndex = false;
        Object[] fields = new String[]{};
        if (this.remaining) {
            String record;
            if (log.isDebugEnabled()) {
                log.debug("Reading record " + this.numberOfRecordsReadThroughChannel + " from " + this.channel.hashCode());
            }
            if (null != (record = this.readRecord())) {
                fields = this.getFields(record);
                ++this.numberOfRecordsReadThroughChannel;
                if (log.isDebugEnabled()) {
                    log.debug("Record " + this.numberOfRecordsReadThroughChannel + " returned " + fields.length + " from " + "channel " + this.channel.hashCode());
                }
                if (log.isTraceEnabled()) {
                    log.trace("The list of fields identified in record " + this.numberOfRecordsReadThroughChannel + "from " + "channel " + this.channel.hashCode() + "," + Arrays.toString(fields));
                }
            }
        } else if (null != this.channel) {
            log.warn("The final record has already being processed through the channel " + this.channel.hashCode());
        } else {
            log.warn("The requested channel has already being closed");
        }
        return fields;
    }

    private String composeRecord(BStringArray fields) {
        StringBuilder recordConsolidator = new StringBuilder();
        long numberOfFields = fields.length();
        boolean fieldStartIndex = false;
        long secondLastFieldIndex = numberOfFields - 1L;
        if (log.isDebugEnabled()) {
            log.debug("Number of fields to be composed " + numberOfFields);
        }
        int fieldCount = 0;
        while ((long)fieldCount < numberOfFields) {
            String currentFieldString = fields.get((long)fieldCount);
            recordConsolidator.append(currentFieldString);
            if ((long)fieldCount < secondLastFieldIndex) {
                recordConsolidator.append(this.fieldSeparator);
            }
            ++fieldCount;
        }
        String finalizedRecord = recordConsolidator.toString();
        return finalizedRecord;
    }

    public void write(BStringArray fields) throws IOException {
        boolean writeOffset = false;
        String record = this.composeRecord(fields);
        record = record + this.recordSeparator;
        if (log.isTraceEnabled()) {
            log.trace("The record " + this.numberOfRecordsWrittenToChannel + " composed for writing, " + record);
        }
        this.channel.write(record, 0);
        if (log.isDebugEnabled()) {
            log.debug("Record " + this.numberOfRecordsReadThroughChannel + " written to the channel " + this.channel.hashCode());
        }
        ++this.numberOfRecordsWrittenToChannel;
    }

    public void close() {
        this.channel.close();
    }
}

